/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.ipsobject;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import org.faktorips.devtools.model.IIpsModel;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.util.ArgumentCheck;

public class QualifiedNameType
implements Serializable,
Comparable<QualifiedNameType> {
    public static final char FILE_EXTENSION_SEPERATOR = '.';
    private static final long serialVersionUID = -5891585006868536302L;
    private String qualifiedName;
    private transient IpsObjectType type;
    private transient int hashCode;
    private transient Path path = null;

    public QualifiedNameType(String name, IpsObjectType type) {
        ArgumentCheck.notNull((Object)name);
        ArgumentCheck.notNull((Object)type);
        this.qualifiedName = name;
        this.type = type;
        this.calculateHashCode();
    }

    public static final QualifiedNameType newQualifedNameType(String pathToFile) {
        if (!QualifiedNameType.representsQualifiedNameType(pathToFile)) {
            throw new IllegalArgumentException("Path " + pathToFile + " does not specifiy an IPS object type.");
        }
        int index = pathToFile.lastIndexOf(46);
        IpsObjectType type = IpsObjectType.getTypeForExtension(pathToFile.substring(index + 1));
        String qNameWithBackslash = pathToFile.substring(0, index).replace('/', '.');
        String qName = qNameWithBackslash.replace('\\', '.');
        return new QualifiedNameType(qName, type);
    }

    public static final boolean representsQualifiedNameType(@CheckForNull String pathToFile) {
        if (pathToFile == null) {
            return false;
        }
        int index = pathToFile.lastIndexOf(46);
        if (index == -1 || index == pathToFile.length() - 1) {
            return false;
        }
        IpsObjectType type = IpsObjectType.getTypeForExtension(pathToFile.substring(index + 1));
        if (type == null) {
            return false;
        }
        String qName = pathToFile.substring(0, index).replace('/', '.');
        return !qName.equals("");
    }

    public String getName() {
        return this.qualifiedName;
    }

    public IpsObjectType getIpsObjectType() {
        return this.type;
    }

    public String getPackageName() {
        int index = this.qualifiedName.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return this.qualifiedName.substring(0, index);
    }

    public String getUnqualifiedName() {
        int index = this.qualifiedName.lastIndexOf(46);
        if (index == -1) {
            return this.qualifiedName;
        }
        if (index == this.qualifiedName.length() - 1) {
            return "";
        }
        return this.qualifiedName.substring(index + 1);
    }

    public Path toPath() {
        if (this.path == null) {
            this.path = Path.of(String.valueOf(this.qualifiedName.replace('.', File.separatorChar)) + '.' + this.type.getFileExtension(), new String[0]);
        }
        return this.path;
    }

    public String getFileName() {
        return this.type.getFileName(this.getUnqualifiedName());
    }

    private void calculateHashCode() {
        int result = 17;
        result = result * 37 + this.qualifiedName.hashCode();
        this.hashCode = result = result * 37 + this.type.hashCode();
    }

    public int hashCode() {
        return this.hashCode;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof QualifiedNameType) {
            void other;
            QualifiedNameType qualifiedNameType = (QualifiedNameType)object;
            QualifiedNameType cfr_ignored_0 = (QualifiedNameType)object;
            return this.type.equals(other.type) && this.qualifiedName.equals(other.qualifiedName);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.type.getDisplayName()) + ": " + this.qualifiedName;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.type.getId());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        String typeName = (String)s.readObject();
        this.type = IIpsModel.get().getIpsObjectType(typeName);
        if (this.type == null) {
            throw new IllegalStateException("Unable to deserialize this qualified name type because the IpsObjectType could not be resolved: " + this.type);
        }
        this.calculateHashCode();
    }

    @Override
    public int compareTo(QualifiedNameType other) {
        int c = this.getPackageName().compareTo(other.getPackageName());
        if (c != 0) {
            return c;
        }
        c = this.getUnqualifiedName().compareTo(other.getUnqualifiedName());
        if (c != 0) {
            return c;
        }
        return this.getIpsObjectType().getId().compareTo(other.getIpsObjectType().getId());
    }
}

