/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.pctype;

import org.faktorips.devtools.model.pctype.Messages;

public enum AttributeType {
    CHANGEABLE("changeable", Messages.AttributeType_changeable),
    DERIVED_BY_EXPLICIT_METHOD_CALL("computed", Messages.AttributeType_derived_by_explicit_method_call),
    DERIVED_ON_THE_FLY("derived", Messages.AttributeType_derived_on_the_fly),
    CONSTANT("constant", Messages.AttributeType_constant);

    private final String id;
    private final String name;

    private AttributeType(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public static final AttributeType getAttributeType(String id) {
        if ("changeable".equals(id)) {
            return CHANGEABLE;
        }
        AttributeType[] attributeTypeArray = AttributeType.values();
        int n = attributeTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeType at = attributeTypeArray[n2];
            if (at.getId().equals(id)) {
                return at;
            }
            ++n2;
        }
        return null;
    }

    public boolean isDerived() {
        return this == DERIVED_BY_EXPLICIT_METHOD_CALL || this == DERIVED_ON_THE_FLY;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }
}

