/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.pctype;

import java.util.Arrays;
import org.faktorips.codegen.JavaCodeFragment;
import org.faktorips.runtime.Severity;
import org.faktorips.util.ArgumentCheck;

public enum MessageSeverity {
    ERROR("error", new JavaCodeFragment().appendClassName(Severity.class).append(".ERROR")),
    WARNING("warning", new JavaCodeFragment().appendClassName(Severity.class).append(".WARNING")),
    INFO("info", new JavaCodeFragment().appendClassName(Severity.class).append(".INFO"));

    private String id;
    private JavaCodeFragment codeFragment;

    private MessageSeverity(String id, JavaCodeFragment fragment) {
        ArgumentCheck.notNull((Object)id);
        this.id = id;
        ArgumentCheck.notNull((Object)fragment);
        this.codeFragment = fragment;
    }

    public static final MessageSeverity getMessageSeverity(String id) {
        return Arrays.stream(MessageSeverity.values()).filter(s -> s.id.equals(id)).findAny().orElse(null);
    }

    public String getId() {
        return this.id;
    }

    public JavaCodeFragment getJavaSourcecode() {
        return new JavaCodeFragment(this.codeFragment);
    }

    public static final int getJFaceMessageType(MessageSeverity severity) {
        if (ERROR.equals((Object)severity)) {
            return 3;
        }
        if (INFO.equals((Object)severity)) {
            return 1;
        }
        if (WARNING.equals((Object)severity)) {
            return 2;
        }
        return 0;
    }
}

