/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.pctype.persistence;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import org.apache.commons.lang3.StringUtils;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.ipsobject.IDescribedElement;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.pctype.IPolicyCmptType;
import org.faktorips.runtime.internal.IpsStringUtils;

public interface IPersistentTypeInfo
extends IIpsObjectPart,
IDescribedElement {
    public static final String XML_TAG = "Persistence";
    public static final String PROPERTY_TABLE_NAME = "tableName";
    public static final String PROPERTY_INHERITANCE_STRATEGY = "inheritanceStrategy";
    public static final String PROPERTY_DISCRIMINATOR_COLUMN_NAME = "discriminatorColumnName";
    public static final String PROPERTY_DISCRIMINATOR_COLUMN_LENGTH = "discriminatorColumnLength";
    public static final String PROPERTY_DISCRIMINATOR_VALUE = "discriminatorValue";
    public static final String PROPERTY_DISCRIMINATOR_DATATYPE = "discriminatorDatatype";
    public static final String PROPERTY_INHERITANCE_NOT_JOINEDSUBCLASS = "notJoinedSubclass";
    public static final String PROPERTY_PERSISTENT_TYPE = "persistentType";
    public static final String PROPERTY_DEFINES_DISCRIMINATOR_COLUMN = "definesDiscriminatorColumn";
    public static final String PROPERTY_USE_TABLE_DEFINED_IN_SUPERTYPE = "useTableDefinedInSupertype";
    public static final String MSGCODE_PREFIX = "PERSISTENCETYPE-";
    public static final String MSGCODE_PERSISTENCE_TABLE_NAME_INVALID = "PERSISTENCETYPE-PersistenceTypeTableNameInvalid";
    public static final String MSGCODE_PERSISTENCE_DISCRIMINATOR_VALUE_INVALID = "PERSISTENCETYPE-PersistenceTypeDiscriminatorInvalid";
    public static final String MSGCODE_PERSISTENCE_INHERITANCE_STRATEGY_INVALID = "PERSISTENCETYPE-PersistenceTypeInheritanceStrategyInvalid";
    public static final String MSGCODE_DEFINITION_OF_DISCRIMINATOR_MISSING = "PERSISTENCETYPE-definitionOfDiscriminatorMissing";
    public static final String MSGCODE_DEFINITION_OF_DISCRIMINATOR_NOT_ALLOWED = "PERSISTENCETYPE-definitionOfDiscriminatorNotAllowed";
    public static final String MSGCODE_USE_TABLE_DEFINED_IN_SUPERTYPE_NOT_ALLOWED = "PERSISTENCETYPE-msgcodeUseTableDefinedInSupertypeNotAllowed";
    public static final String MSGCODE_PERSISTENCEATTR_DUPLICATE_COLNAME = "PERSISTENCETYPE-PersistenceAttrColumnNameDuplicate";
    public static final String MSGCODE_MUST_USE_TABLE_FROM_ROOT_ENTITY = "PERSISTENCETYPE-MustUseTableFromRootEntity";

    public IPolicyCmptType getPolicyCmptType();

    public PersistentType getPersistentType();

    public boolean isEnabled();

    public void setPersistentType(PersistentType var1);

    public boolean isDefinesDiscriminatorColumn();

    public void setDefinesDiscriminatorColumn(boolean var1);

    public boolean isUseTableDefinedInSupertype();

    public void setUseTableDefinedInSupertype(boolean var1);

    public IPolicyCmptType findRootEntity() throws IpsException;

    public String getTableName();

    public void setTableName(String var1);

    public InheritanceStrategy getInheritanceStrategy();

    public void setInheritanceStrategy(InheritanceStrategy var1);

    public String getDiscriminatorColumnName();

    public void setDiscriminatorColumnName(String var1);

    @CheckForNull
    public Integer getDiscriminatorColumnLength();

    public void setDiscriminatorColumnLength(@CheckForNull Integer var1);

    public String getDiscriminatorValue();

    public void setDiscriminatorValue(String var1);

    public DiscriminatorDatatype getDiscriminatorDatatype();

    public void setDiscriminatorDatatype(DiscriminatorDatatype var1);

    public static enum DiscriminatorDatatype {
        VOID,
        STRING,
        CHAR,
        INTEGER;


        public boolean isParsableToDiscriminatorDatatype(String value) {
            return switch (this) {
                case STRING -> IpsStringUtils.isNotEmpty((String)value);
                case CHAR -> {
                    if (IpsStringUtils.isNotEmpty((String)value) && value.length() == 1) {
                        yield true;
                    }
                    yield false;
                }
                case INTEGER -> {
                    if (IpsStringUtils.isNotEmpty((String)value) && StringUtils.isNumeric((CharSequence)value)) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
    }

    public static enum InheritanceStrategy {
        SINGLE_TABLE,
        JOINED_SUBCLASS;

    }

    public static enum PersistentType {
        NONE,
        ENTITY,
        MAPPED_SUPERCLASS;

    }
}

