/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.util.ArgumentCheck;

public class ExtensionPoints {
    public static final String PULL_UP_PARTICIPANTS = "pullUpParticipants";
    public static final String CONFIG_ELEMENT_PROPERTY_PROVIDER = "provider";
    public static final String CONFIG_ELEMENT_PROPERTY_CLASS = "class";
    private final IExtensionRegistry registry;
    private final String nameSpace;

    public ExtensionPoints(IExtensionRegistry registry, String nameSpace) {
        ArgumentCheck.notNull((Object)registry, (Object)this);
        ArgumentCheck.notNull((Object)nameSpace, (Object)this);
        this.registry = registry;
        this.nameSpace = nameSpace;
    }

    public ExtensionPoints(String nameSpace) {
        this(Platform.getExtensionRegistry(), nameSpace);
    }

    public ExtensionPoints() {
        this(Platform.getExtensionRegistry(), "org.faktorips.devtools.model");
    }

    public final IExtension[] getExtension(String pointId) {
        ArgumentCheck.notNull((Object)pointId);
        IExtensionPoint point = this.getRegistry().getExtensionPoint(this.getNameSpace(), pointId);
        if (point == null) {
            IpsLog.log((IStatus)new IpsStatus("ExtensionPoint " + pointId + " not found!"));
            throw new IllegalArgumentException("Unknown extension point " + pointId);
        }
        return point.getExtensions();
    }

    public final <T> List<T> createExecutableExtensions(String pointId, String elementName, String propertyName, Class<T> expectedType) {
        return this.createExecutableExtensions(pointId, elementName, propertyName, expectedType, ($1, $2) -> {});
    }

    public <T> List<T> createExecutableExtensions(String pointId, String elementName, String propertyName, Class<T> expectedType, BiConsumer<IExtension, T> initializer) {
        ArgumentCheck.notNull((Object)pointId);
        return Arrays.stream(this.getExtension(pointId)).flatMap(extension -> ExtensionPoints.createAndInitialize(elementName, propertyName, expectedType, initializer, extension).stream()).collect(Collectors.toList());
    }

    private static <T> List<T> createAndInitialize(String elementName, String propertyName, Class<T> expectedType, BiConsumer<IExtension, T> initializer, IExtension extension) {
        List<Object> executables = ExtensionPoints.createExecutableExtensions(extension, elementName, propertyName, expectedType);
        executables.forEach(ex -> initializer.accept(extension, ex));
        return executables;
    }

    public static final <T> List<T> createExecutableExtensions(IExtension extension, String elementName, String propertyName, Class<T> expectedType) {
        IConfigurationElement[] configElements = extension.getConfigurationElements();
        ArrayList<T> executables = new ArrayList<T>(configElements.length);
        if (configElements.length == 0) {
            String text = "No config elements with name " + elementName + " found in extension " + extension.getUniqueIdentifier() + ".";
            IpsLog.log((IStatus)new IpsStatus(2, text));
            return executables;
        }
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            T newExecutable;
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            if (elementName.equalsIgnoreCase(configElement.getName()) && (newExecutable = ExtensionPoints.createExecutableExtension(extension, configElement, propertyName, expectedType)) != null) {
                executables.add(newExecutable);
            }
            ++n2;
        }
        return executables;
    }

    public static final <T> T createExecutableExtension(IExtension extension, String elementName, String propertyName, Class<T> expectedType) {
        IConfigurationElement[] configElements;
        IConfigurationElement configElement = null;
        IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement2 = iConfigurationElementArray[n2];
            if (elementName.equalsIgnoreCase(configElement2.getName())) {
                configElement = configElement2;
            }
            ++n2;
        }
        if (configElement == null) {
            String text = "Can't cerate executable extension " + extension.getUniqueIdentifier() + ". No config element with name " + elementName + " found.";
            IpsLog.log((IStatus)new IpsStatus(text));
            return null;
        }
        return ExtensionPoints.createExecutableExtension(extension, configElement, propertyName, expectedType);
    }

    public static final <T> T createExecutableExtension(IExtension extension, IConfigurationElement element, String propertyName, Class<T> expectedType) {
        return ExtensionPoints.createExecutableExtension(extension.getUniqueIdentifier(), element, propertyName, expectedType);
    }

    public static final <T> T createExecutableExtension(String extensionId, IConfigurationElement element, String propertyName, Class<T> expectedType) {
        Object object;
        block3: {
            object = null;
            try {
                object = element.createExecutableExtension(propertyName);
                if (object != null) break block3;
                IpsLog.log((IStatus)new IpsStatus("Unable to create extension " + extensionId + ". Reason: " + propertyName + " is null"));
            }
            catch (Exception e) {
                IpsLog.log((IStatus)new IpsStatus("Unable to create extension " + extensionId + ". Reason: Can't instantiate " + element.getAttribute(propertyName), e));
                return null;
            }
            return null;
        }
        if (!expectedType.isAssignableFrom(object.getClass())) {
            IpsLog.log((IStatus)new IpsStatus("Unable to create extension " + extensionId + "Reason: " + element.getAttribute(propertyName) + " is not of type " + expectedType));
            return null;
        }
        return expectedType.cast(object);
    }

    public static final Stream<IConfigurationElement> getConfigurationElements(IExtension extension, String elementName) {
        return Arrays.stream(extension.getConfigurationElements()).filter(configElement -> elementName.equalsIgnoreCase(configElement.getName()));
    }

    public IExtensionRegistry getRegistry() {
        return this.registry;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }
}

