/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.plugin;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ClasspathVariableInitializer;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.osgi.framework.Bundle;

public class FaktorIpsClasspathVariableInitializer
extends ClasspathVariableInitializer {
    public static final String VARNAME_VALUETYPES_JAVA5_BIN = "FAKTORIPS_VALUETYPES_JAVA5";
    public static final String VARNAME_VALUETYPES_JAVA5_SRC = "FAKTORIPS_VALUETYPES_JAVA5_SRC";
    public static final String VARNAME_RUNTIME_JAVA5_BIN = "FAKTORIPS_RUNTIME_JAVA5";
    public static final String VARNAME_RUNTIME_JAVA5_SRC = "FAKTORIPS_RUNTIME_JAVA5_SRC";
    public static final String[] IPS_VARIABLES_JAVA5_BIN = new String[]{"FAKTORIPS_VALUETYPES_JAVA5", "FAKTORIPS_RUNTIME_JAVA5"};
    public static final String[] IPS_VARIABLES_JAVA5_SRC = new String[]{"FAKTORIPS_VALUETYPES_JAVA5_SRC", "FAKTORIPS_RUNTIME_JAVA5_SRC"};
    private final HashMap<String, Mapping> varMapping = new HashMap();

    public FaktorIpsClasspathVariableInitializer() {
        this.add(new Mapping(VARNAME_VALUETYPES_JAVA5_BIN, "org.faktorips.valuetypes", "/"));
        this.add(new Mapping(VARNAME_VALUETYPES_JAVA5_SRC, "org.faktorips.valuetypes", "/src.zip"));
        this.add(new Mapping(VARNAME_RUNTIME_JAVA5_BIN, "org.faktorips.runtime", "/"));
        this.add(new Mapping(VARNAME_RUNTIME_JAVA5_SRC, "org.faktorips.runtime", "/src.zip"));
    }

    protected void add(Mapping m) {
        this.varMapping.put(m.getVarName(), m);
    }

    private Mapping getMapping(String varName) {
        return this.varMapping.get(varName);
    }

    public void initialize(String variable) {
        Mapping m = this.getMapping(variable);
        if (m == null) {
            return;
        }
        Bundle bundle = Platform.getBundle((String)m.getPluginId());
        if (bundle == null) {
            IpsLog.log((IStatus)new IpsStatus("Error initializing classpath variable " + variable + ". Bundle " + m.pluginId + "not found."));
            return;
        }
        URL installLocation = bundle.getEntry(m.jarName);
        if (installLocation == null) {
            IPath previous = JavaCore.getClasspathVariable((String)variable);
            if (previous == null) {
                return;
            }
            try {
                JavaCore.setClasspathVariable((String)variable, (IPath)previous, null);
            }
            catch (JavaModelException e) {
                IpsLog.log((IStatus)new IpsStatus("Error initializing classpath variable " + variable, e));
            }
            return;
        }
        URL local = null;
        try {
            local = FileLocator.toFileURL((URL)installLocation);
        }
        catch (Exception e) {
            IpsLog.log((IStatus)new IpsStatus("Error initializing classpath variable " + variable + ". Bundle install locaction: " + installLocation, e));
            return;
        }
        try {
            File file = new File(local.getPath());
            String fullPath = file.getAbsolutePath();
            if (file.exists()) {
                JavaCore.setClasspathVariable((String)variable, (IPath)Path.fromOSString((String)fullPath), null);
            }
        }
        catch (JavaModelException e1) {
            IpsLog.log((IStatus)new IpsStatus("Error initializing classpath variable " + variable, e1));
        }
    }

    protected class Mapping {
        private final String varName;
        private final String pluginId;
        private final String jarName;

        public Mapping(String varName, String pluginId, String jarName) {
            this.varName = varName;
            this.pluginId = pluginId;
            this.jarName = jarName;
        }

        public String getJarName() {
            return this.jarName;
        }

        public String getPluginId() {
            return this.pluginId;
        }

        public String getVarName() {
            return this.varName;
        }
    }
}

