/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.plugin;

import org.faktorips.datatype.EnumDatatype;
import org.faktorips.datatype.NamedDatatype;
import org.faktorips.datatype.PrimitiveBooleanDatatype;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.datatype.classtypes.BooleanDatatype;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.enums.EnumTypeDatatypeAdapter;
import org.faktorips.devtools.model.plugin.Messages;
import org.faktorips.devtools.model.plugin.NamedDataTypeDisplay;

public interface IDatatypeFormatter {
    public static final String DEFAULT_NULL_REPRESENTATION = "<null>";

    default public String formatValue(ValueDatatype datatype, String value) {
        if (value == null) {
            return this.getNullPresentation();
        }
        if (datatype == null) {
            return value;
        }
        if (datatype instanceof EnumTypeDatatypeAdapter) {
            return this.formatValue((NamedDatatype)((EnumDatatype)datatype), value);
        }
        if (datatype instanceof NamedDatatype) {
            return this.formatValue((NamedDatatype)datatype, value);
        }
        if (datatype instanceof BooleanDatatype || datatype instanceof PrimitiveBooleanDatatype) {
            if (Boolean.parseBoolean(value)) {
                return Messages.DatatypeFormatter_booleanTrue;
            }
            return Messages.DatatypeFormatter_booleanFalse;
        }
        return value;
    }

    default public String formatValue(NamedDatatype datatype, String id) {
        if (!datatype.isSupportingNames()) {
            return id;
        }
        NamedDataTypeDisplay dataTypeDisplay = this.getNamedDataTypeDisplay();
        if (dataTypeDisplay.equals((Object)NamedDataTypeDisplay.ID) || !datatype.isParsable(id)) {
            return id;
        }
        String name = datatype.getValueName(id, IIpsModelExtensions.get().getModelPreferences().getDatatypeFormattingLocale());
        if (name == null) {
            return id;
        }
        if (dataTypeDisplay.equals((Object)NamedDataTypeDisplay.NAME)) {
            return name;
        }
        if (dataTypeDisplay.equals((Object)NamedDataTypeDisplay.NAME_AND_ID)) {
            return String.valueOf(name) + " (" + id + ")";
        }
        return id;
    }

    default public String getNullPresentation() {
        return DEFAULT_NULL_REPRESENTATION;
    }

    default public NamedDataTypeDisplay getNamedDataTypeDisplay() {
        return NamedDataTypeDisplay.NAME_AND_ID;
    }
}

