/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.plugin;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.faktorips.devtools.model.plugin.IpsLog;

public class IpsCompositeSaveParticipant
implements ISaveParticipant {
    private Set<ISaveParticipant> saveParticipants = new HashSet<ISaveParticipant>();

    public void addSaveParticipant(ISaveParticipant participant) {
        if (participant == null) {
            return;
        }
        this.saveParticipants.add(participant);
    }

    public boolean removeSaveParticipant(ISaveParticipant participant) {
        return this.saveParticipants.remove(participant);
    }

    public void doneSaving(ISaveContext context) {
        for (ISaveParticipant participant : this.saveParticipants) {
            try {
                participant.doneSaving(context);
            }
            catch (Exception e) {
                IpsLog.log(e);
            }
        }
    }

    public void prepareToSave(ISaveContext context) {
        for (ISaveParticipant participant : this.saveParticipants) {
            try {
                participant.prepareToSave(context);
            }
            catch (Exception e) {
                IpsLog.log(e);
            }
        }
    }

    public void rollback(ISaveContext context) {
        for (ISaveParticipant participant : this.saveParticipants) {
            try {
                participant.rollback(context);
            }
            catch (Exception e) {
                IpsLog.log(e);
            }
        }
    }

    public void saving(ISaveContext context) {
        for (ISaveParticipant participant : this.saveParticipants) {
            try {
                participant.saving(context);
            }
            catch (Exception e) {
                IpsLog.log(e);
            }
        }
    }
}

