/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.plugin;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.devtools.abstraction.ALog;
import org.faktorips.devtools.abstraction.Abstractions;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.plugin.IpsModelActivator;
import org.faktorips.devtools.model.plugin.IpsStatus;

public class IpsLog {
    private static boolean suppressLoggingDuringTestExecution;

    private IpsLog() {
    }

    public static ALog get() {
        return Abstractions.getLog();
    }

    public static final void log(IStatus status) {
        if (IpsLog.isStarted() && !suppressLoggingDuringTestExecution) {
            IpsLog.get().log(status);
        }
    }

    private static boolean isStarted() {
        return !Abstractions.isEclipseRunning() || IpsModelActivator.isStarted();
    }

    public static final void log(CoreException e) {
        IpsLog.log(e.getStatus());
    }

    public static final void log(Throwable t) {
        IpsLog.log((IStatus)new IpsStatus(t));
    }

    public static final void logAndShowErrorDialog(IStatus status) {
        IpsLog.log(status);
        IIpsModelExtensions.get().getWorkspaceInteractions().showErrorDialog(status);
    }

    public static final void logAndShowErrorDialog(Exception e) {
        IpsLog.logAndShowErrorDialog((IStatus)new IpsStatus(e));
    }

    public static final void logAndShowErrorDialog(CoreException e) {
        IpsLog.logAndShowErrorDialog(e.getStatus());
    }

    public static void setSuppressLoggingDuringTest(boolean suppress) {
        suppressLoggingDuringTestExecution = suppress;
    }

    public static boolean isSuppressLoggingDuringTestExecution() {
        return suppressLoggingDuringTestExecution;
    }
}

