/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.plugin;

import java.util.ArrayList;
import java.util.List;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.plugin.IpsValidationTask;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.util.ArgumentCheck;

public final class IpsValidation {
    private final List<IpsValidationTask> tasks = new ArrayList<IpsValidationTask>(1);

    public MessageList validate(IIpsProject ipsProject) {
        ArgumentCheck.notNull((Object)ipsProject);
        MessageList messageList = new MessageList();
        for (IpsValidationTask task : this.tasks) {
            Message taskResult = task.execute(ipsProject);
            if (taskResult == null) continue;
            messageList.add(taskResult);
            if (taskResult.getSeverity() == Message.ERROR && !task.isContinueOnError()) break;
        }
        return messageList;
    }

    public void addTask(IpsValidationTask task) {
        ArgumentCheck.notNull((Object)task);
        this.tasks.add(task);
    }
}

