/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.plugin;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.faktorips.devtools.abstraction.Abstractions;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.IMultiLanguageSupport;
import org.faktorips.devtools.model.ipsobject.IDescribedElement;
import org.faktorips.devtools.model.ipsobject.IDescription;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPartContainer;
import org.faktorips.devtools.model.ipsobject.ILabel;
import org.faktorips.devtools.model.ipsobject.ILabeledElement;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.ipsproject.IIpsProjectProperties;
import org.faktorips.devtools.model.ipsproject.ISupportedLanguage;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.plugin.Messages;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeMethod;
import org.faktorips.devtools.model.type.IAssociation;
import org.faktorips.devtools.model.type.IOverridableElement;
import org.faktorips.devtools.model.type.IOverridableLabeledElement;
import org.faktorips.devtools.model.value.IValue;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.faktorips.util.ArgumentCheck;

public class MultiLanguageSupport
implements IMultiLanguageSupport {
    private final Locale localizationLocale;
    private final Locale usedLanguagePackLocale;

    public MultiLanguageSupport() {
        this(MultiLanguageSupport.getPlatformLocale());
    }

    public MultiLanguageSupport(Locale localizationLocale) {
        ArgumentCheck.notNull((Object)localizationLocale);
        this.localizationLocale = localizationLocale;
        this.usedLanguagePackLocale = new Locale(Messages.IpsPlugin_languagePackLanguage, Messages.IpsPlugin_languagePackCountry, Messages.IpsPlugin_languagePackVariant);
    }

    private static Locale getPlatformLocale() {
        return Abstractions.getLocale();
    }

    @Override
    public Locale getUsedLanguagePackLocale() {
        return this.usedLanguagePackLocale;
    }

    @Override
    public String getLocalizedCaption(IIpsObjectPartContainer ipsObjectPartContainer) {
        ArgumentCheck.notNull((Object)ipsObjectPartContainer);
        String localizedCaption = null;
        try {
            localizedCaption = ipsObjectPartContainer.getCaption(this.getLocalizationLocale());
        }
        catch (IpsException e) {
            IpsLog.log(e);
        }
        if (IpsStringUtils.isEmpty((String)localizedCaption)) {
            localizedCaption = this.getDefaultCaption(ipsObjectPartContainer);
        }
        return localizedCaption;
    }

    @Override
    public String getLocalizedPluralCaption(IIpsObjectPartContainer ipsObjectPartContainer) {
        ArgumentCheck.notNull((Object)ipsObjectPartContainer);
        String localizedPluralCaption = null;
        try {
            localizedPluralCaption = ipsObjectPartContainer.getPluralCaption(this.getLocalizationLocale());
        }
        catch (IpsException e) {
            IpsLog.log(e);
        }
        if (IpsStringUtils.isEmpty((String)localizedPluralCaption)) {
            localizedPluralCaption = this.getDefaultPluralCaption(ipsObjectPartContainer);
        }
        return localizedPluralCaption;
    }

    @Override
    public String getDefaultCaption(IIpsObjectPartContainer ipsObjectPartContainer) {
        ArgumentCheck.notNull((Object)ipsObjectPartContainer);
        String defaultCaption = null;
        Locale defaultLocale = this.getDefaultLocale(ipsObjectPartContainer.getIpsProject());
        if (defaultLocale != null) {
            try {
                defaultCaption = ipsObjectPartContainer.getCaption(defaultLocale);
            }
            catch (IpsException e) {
                IpsLog.log(e);
            }
        }
        if (IpsStringUtils.isEmpty(defaultCaption)) {
            defaultCaption = ipsObjectPartContainer.getLastResortCaption();
        }
        return defaultCaption;
    }

    @Override
    public String getDefaultPluralCaption(IIpsObjectPartContainer ipsObjectPartContainer) {
        ArgumentCheck.notNull((Object)ipsObjectPartContainer);
        String defaultPluralCaption = null;
        Locale defaultLocale = this.getDefaultLocale(ipsObjectPartContainer.getIpsProject());
        if (defaultLocale != null) {
            try {
                defaultPluralCaption = ipsObjectPartContainer.getPluralCaption(defaultLocale);
            }
            catch (IpsException e) {
                IpsLog.log(e);
            }
        }
        if (IpsStringUtils.isEmpty(defaultPluralCaption)) {
            defaultPluralCaption = ipsObjectPartContainer.getLastResortPluralCaption();
        }
        return defaultPluralCaption;
    }

    @Override
    public String getLocalizedLabel(ILabeledElement labeledElement) {
        ArgumentCheck.notNull((Object)labeledElement);
        String label = labeledElement instanceof IOverridableLabeledElement ? ((IOverridableLabeledElement)labeledElement).getLabelValueFromThisOrSuper(this.getLocalizationLocale()) : labeledElement.getLabelValue(this.getLocalizationLocale());
        return IpsStringUtils.isEmpty((String)label) ? this.getDefaultLabel(labeledElement) : label;
    }

    @Override
    public String getLocalizedPluralLabel(ILabeledElement labeledElement) {
        ArgumentCheck.notNull((Object)labeledElement);
        ArgumentCheck.isTrue((boolean)labeledElement.isPluralLabelSupported());
        String pluralLabel = labeledElement instanceof IAssociation ? ((IAssociation)labeledElement).getPluralLabelValueFromThisOrSuper(this.getLocalizationLocale()) : labeledElement.getPluralLabelValue(this.getLocalizationLocale());
        return IpsStringUtils.isEmpty((String)pluralLabel) ? this.getDefaultPluralLabel(labeledElement) : pluralLabel;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getDefaultLabel(ILabeledElement labeledElement) {
        String value;
        ArgumentCheck.notNull((Object)labeledElement);
        String label = StringUtils.capitalize((String)labeledElement.getName());
        ILabeledElement iLabeledElement = labeledElement;
        if (iLabeledElement instanceof IProductCmptTypeMethod) {
            void method;
            IProductCmptTypeMethod iProductCmptTypeMethod = (IProductCmptTypeMethod)iLabeledElement;
            IProductCmptTypeMethod cfr_ignored_0 = (IProductCmptTypeMethod)iLabeledElement;
            if (method.isFormulaSignatureDefinition()) {
                label = StringUtils.capitalize((String)method.getFormulaName());
            }
        }
        return IpsStringUtils.isEmpty((String)(value = this.getDefaultLabelValue(labeledElement))) ? label : value;
    }

    private String getDefaultLabelValue(ILabeledElement labeledElement) {
        Locale defaultLocale = this.getDefaultLocale(labeledElement.getIpsProject());
        if (defaultLocale != null) {
            if (labeledElement instanceof IOverridableLabeledElement) {
                return ((IOverridableLabeledElement)labeledElement).getLabelValueFromThisOrSuper(defaultLocale);
            }
            return labeledElement.getLabelValue(defaultLocale);
        }
        return "";
    }

    @Override
    public String getDefaultPluralLabel(ILabeledElement labeledElement) {
        String value;
        ArgumentCheck.notNull((Object)labeledElement);
        ArgumentCheck.isTrue((boolean)labeledElement.isPluralLabelSupported());
        String pluralLabel = StringUtils.capitalize((String)labeledElement.getName());
        if (labeledElement instanceof IAssociation) {
            pluralLabel = StringUtils.capitalize((String)((IAssociation)labeledElement).getTargetRolePlural());
        }
        return IpsStringUtils.isEmpty((String)(value = this.getDefaultPluralLabelValue(labeledElement))) ? pluralLabel : value;
    }

    private String getDefaultPluralLabelValue(ILabeledElement labeledElement) {
        Locale defaultLocale = this.getDefaultLocale(labeledElement.getIpsProject());
        if (defaultLocale != null) {
            if (labeledElement instanceof IAssociation) {
                return ((IAssociation)labeledElement).getPluralLabelValueFromThisOrSuper(defaultLocale);
            }
            return labeledElement.getPluralLabelValue(defaultLocale);
        }
        return "";
    }

    public void setDefaultLabel(ILabeledElement labeledElement, String value) {
        ArgumentCheck.notNull((Object)labeledElement);
        ILabel defaultLabel = this.getDefaultLabelPart(labeledElement);
        if (defaultLabel != null) {
            defaultLabel.setValue(value);
        }
    }

    public void setDefaultPluralLabel(ILabeledElement labeledElement, String pluralValue) {
        ArgumentCheck.notNull((Object)labeledElement);
        ArgumentCheck.isTrue((boolean)labeledElement.isPluralLabelSupported());
        ILabel defaultLabel = this.getDefaultLabelPart(labeledElement);
        if (defaultLabel != null) {
            defaultLabel.setPluralValue(pluralValue);
        }
    }

    @Override
    public String getLocalizedDescription(IDescribedElement describedElement) {
        ArgumentCheck.notNull((Object)describedElement);
        String description = "";
        description = describedElement instanceof IOverridableElement ? ((IOverridableElement)describedElement).getDescriptionTextFromThisOrSuper(this.getLocalizationLocale()) : describedElement.getDescriptionText(this.getLocalizationLocale());
        return IpsStringUtils.isEmpty((String)description) ? this.getDefaultDescription(describedElement) : description;
    }

    @Override
    public String getDefaultDescription(IDescribedElement describedElement) {
        ArgumentCheck.notNull((Object)describedElement);
        String text = this.getDefaultDescriptionText(describedElement);
        return IpsStringUtils.isEmpty((String)text) ? "" : text;
    }

    private String getDefaultDescriptionText(IDescribedElement describedElement) {
        Locale defaultLocale = this.getDefaultLocale(describedElement.getIpsProject());
        if (defaultLocale != null) {
            if (describedElement instanceof IOverridableElement) {
                return ((IOverridableElement)describedElement).getDescriptionTextFromThisOrSuper(defaultLocale);
            }
            return describedElement.getDescriptionText(defaultLocale);
        }
        return null;
    }

    public void setDefaultDescription(IDescribedElement describedElement, String text) {
        ArgumentCheck.notNull((Object[])new Object[]{describedElement, text});
        IDescription defaultDescription = this.getDefaultDescriptionPart(describedElement);
        if (defaultDescription != null) {
            defaultDescription.setText(text);
        }
    }

    private ILabel getDefaultLabelPart(ILabeledElement labeledElement) {
        ILabel labelPart = null;
        Locale defaultLocale = this.getDefaultLocale(labeledElement.getIpsProject());
        if (defaultLocale != null) {
            labelPart = labeledElement.getLabel(defaultLocale);
        }
        return labelPart;
    }

    private IDescription getDefaultDescriptionPart(IDescribedElement describedElement) {
        IDescription descriptionPart = null;
        Locale defaultLocale = this.getDefaultLocale(describedElement.getIpsProject());
        if (defaultLocale != null) {
            descriptionPart = describedElement.getDescription(defaultLocale);
        }
        return descriptionPart;
    }

    private Locale getDefaultLocale(IIpsProject ipsProject) {
        return ipsProject.getReadOnlyProperties().getDefaultLanguage().getLocale();
    }

    @Override
    public Locale getLocalizationLocale() {
        return this.localizationLocale;
    }

    @Override
    public Locale getLocalizationLocaleOrDefault(IIpsProject ipsProject) {
        IIpsProjectProperties readOnlyProperties = ipsProject.getReadOnlyProperties();
        ISupportedLanguage supportedLanguage = readOnlyProperties.getSupportedLanguage(this.localizationLocale);
        if (supportedLanguage == null) {
            supportedLanguage = readOnlyProperties.getDefaultLanguage();
        }
        return supportedLanguage.getLocale();
    }

    @Override
    public String getLocalizedContent(IValue<?> value, IIpsProject ipsProject) {
        String localizedContent = value.getLocalizedContent(this.getLocalizationLocale());
        if (IpsStringUtils.isEmpty((String)localizedContent) && IpsStringUtils.isEmpty((String)(localizedContent = value.getDefaultLocalizedContent(ipsProject)))) {
            localizedContent = value.getLocalizedContent();
        }
        return localizedContent;
    }
}

