/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.plugin.extensions;

import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.faktorips.devtools.model.plugin.ExtensionPoints;
import org.faktorips.devtools.model.plugin.extensions.CachingSupplier;

public abstract class AbstractLazyExtension<P, T, E>
extends CachingSupplier<E> {
    private final ExtensionPoints extensionPoints;
    private final String extensionPointId;
    private final String configElementAttribute;
    private final Class<P> extensionClass;
    private final Function<P, T> extensionCreator;

    public AbstractLazyExtension(ExtensionPoints extensionPoints, String extensionPointId, String configElementAttribute, Class<P> extensionClass, Function<P, T> extensionCreator) {
        this.extensionPoints = extensionPoints;
        this.extensionPointId = extensionPointId;
        this.configElementAttribute = configElementAttribute;
        this.extensionClass = extensionClass;
        this.extensionCreator = extensionCreator;
    }

    protected abstract E initializeExtension();

    @Override
    protected E initializeValue() {
        return this.initializeExtension();
    }

    protected Stream<IConfigurationElement> getConfigElements() {
        return Arrays.stream(this.extensionPoints.getRegistry().getConfigurationElementsFor(this.extensionPoints.getNameSpace(), this.extensionPointId));
    }

    protected T create(IConfigurationElement configElement) {
        P executable = ExtensionPoints.createExecutableExtension(this.getExtensionPointId(), configElement, this.getConfigElementAttribute(), this.getExtensionClass());
        return this.extensionCreator.apply(executable);
    }

    public String getExtensionPointId() {
        return this.extensionPointId;
    }

    public String getConfigElementAttribute() {
        return this.configElementAttribute;
    }

    public Class<P> getExtensionClass() {
        return this.extensionClass;
    }
}

