/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.plugin.extensions;

import java.util.function.Supplier;

public abstract class CachingSupplier<T>
implements Supplier<T> {
    private volatile T value;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        T result = this.value;
        if (result != null) {
            return result;
        }
        CachingSupplier cachingSupplier = this;
        synchronized (cachingSupplier) {
            if (this.value == null) {
                this.value = this.initializeValue();
            }
            return this.value;
        }
    }

    protected abstract T initializeValue();

    public static <T> CachingSupplier<T> caching(final Supplier<T> originalSupplier) {
        return new CachingSupplier<T>(){

            @Override
            protected T initializeValue() {
                return originalSupplier.get();
            }
        };
    }
}

