/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.plugin.extensions;

import org.faktorips.devtools.model.IClassLoaderProvider;
import org.faktorips.devtools.model.IClassLoaderProviderFactory;
import org.faktorips.devtools.model.ipsproject.IClasspathContentsChangeListener;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.plugin.ExtensionPoints;
import org.faktorips.devtools.model.plugin.extensions.SimpleSingleLazyExtension;

public class ClassLoaderProviderFactoryExtension
extends SimpleSingleLazyExtension<IClassLoaderProviderFactory> {
    public static final String EXTENSION_POINT_ID_CLASSLOADER_PROVIDER_FACTORY = "classLoaderProviderFactory";

    public ClassLoaderProviderFactoryExtension(ExtensionPoints extensionPoints) {
        super(extensionPoints, EXTENSION_POINT_ID_CLASSLOADER_PROVIDER_FACTORY, "class", IClassLoaderProviderFactory.class, () -> new SimpleClassLoaderProviderFactory());
    }

    private static interface ISimpleClassLoaderProvider
    extends IClassLoaderProvider {
        @Override
        default public void addClasspathChangeListener(IClasspathContentsChangeListener listener) {
        }

        @Override
        default public void removeClasspathChangeListener(IClasspathContentsChangeListener listener) {
        }
    }

    private static final class SimpleClassLoaderProviderFactory
    implements IClassLoaderProviderFactory {
        private SimpleClassLoaderProviderFactory() {
        }

        @Override
        public IClassLoaderProvider getClassLoaderProvider(IIpsProject ipsProject) {
            return () -> ipsProject.getClass().getClassLoader();
        }

        @Override
        public IClassLoaderProvider getClassLoaderProvider(IIpsProject ipsProject, ClassLoader parent) {
            return () -> parent;
        }
    }
}

