/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.plugin.extensions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.devtools.model.extproperties.ExtensionPropertyDefinition;
import org.faktorips.devtools.model.extproperties.IExtensionPropertyDefinition;
import org.faktorips.devtools.model.plugin.ExtensionPoints;
import org.faktorips.devtools.model.plugin.IpsLog;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.devtools.model.plugin.extensions.LazyCollectionExtension;
import org.faktorips.runtime.internal.IpsStringUtils;

public class ExtensionPropertyDefinitionExtensions
extends LazyCollectionExtension<IExtensionPropertyDefinition, Map<Class<?>, List<IExtensionPropertyDefinition>>> {
    public static final String EXTENSION_POINT_ID_OBJECT_EXTENSION_PROPERTY = "objectExtensionProperty";

    public ExtensionPropertyDefinitionExtensions(ExtensionPoints extensionPoints) {
        super(extensionPoints, EXTENSION_POINT_ID_OBJECT_EXTENSION_PROPERTY, "class", IExtensionPropertyDefinition.class, HashMap::new, (configElement, extProperty, typeExtensionPropertiesMap) -> {
            ExtensionPropertyDefinitionExtensions.initExtensionProperty((ExtensionPropertyDefinition)extProperty, configElement);
            typeExtensionPropertiesMap.computeIfAbsent(extProperty.getExtendedType(), $ -> new ArrayList()).add(extProperty);
        }, map -> map.values().forEach(Collections::sort));
    }

    static void initExtensionProperty(ExtensionPropertyDefinition extProperty, IConfigurationElement element) {
        IExtension extension = element.getDeclaringExtension();
        extProperty.setPropertyId(extension.getUniqueIdentifier());
        extProperty.setName(extension.getLabel());
        extProperty.setDefaultValue(element.getAttribute("defaultValue"));
        extProperty.setPosition(element.getAttribute("position"));
        String retentionString = element.getAttribute("retention");
        if (IpsStringUtils.isEmpty((String)retentionString)) {
            extProperty.setRetention(IExtensionPropertyDefinition.RetentionPolicy.RUNTIME);
        } else {
            extProperty.setRetention(IExtensionPropertyDefinition.RetentionPolicy.valueOf(retentionString));
        }
        if (IpsStringUtils.isNotEmpty((String)element.getAttribute("order"))) {
            extProperty.setSortOrder(Integer.parseInt(element.getAttribute("order")));
        }
        String extType = element.getAttribute("extendedType");
        try {
            extProperty.setExtendedType(extProperty.getClass().getClassLoader().loadClass(extType));
        }
        catch (ClassNotFoundException e) {
            IpsLog.log((IStatus)new IpsStatus("Extended type " + extType + " not found for extension property " + extProperty.getPropertyId(), e));
        }
    }
}

