/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.plugin.extensions;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IConfigurationElement;
import org.faktorips.devtools.model.plugin.ExtensionPoints;
import org.faktorips.devtools.model.plugin.extensions.AbstractLazyExtension;
import org.faktorips.devtools.model.util.Consumers;
import org.faktorips.devtools.model.util.TriConsumer;

public class LazyCollectionExtension<P, C>
extends AbstractLazyExtension<P, P, C> {
    private final Supplier<C> collectionCreator;
    private final TriConsumer<IConfigurationElement, P, C> elementCollector;
    private final Consumer<C> collectionFinalizer;

    public LazyCollectionExtension(ExtensionPoints extensionPoints, String extensionPointId, String configElementAttribute, Class<P> extensionClass, Supplier<C> collectionCreator, TriConsumer<IConfigurationElement, P, C> elementCollector, Consumer<C> collectionFinalizer) {
        super(extensionPoints, extensionPointId, configElementAttribute, extensionClass, Function.identity());
        this.collectionCreator = collectionCreator;
        this.elementCollector = elementCollector;
        this.collectionFinalizer = collectionFinalizer;
    }

    public LazyCollectionExtension(ExtensionPoints extensionPoints, String extensionPointId, String configElementAttribute, Class<P> extensionClass, Supplier<C> collectionCreator, TriConsumer<IConfigurationElement, P, C> elementCollector) {
        this(extensionPoints, extensionPointId, configElementAttribute, extensionClass, collectionCreator, elementCollector, Consumers.ignore());
    }

    @Override
    protected C initializeExtension() {
        C collection = this.collectionCreator.get();
        this.getConfigElements().forEach(configElement -> {
            Object element = this.create((IConfigurationElement)configElement);
            if (element != null) {
                this.elementCollector.accept((IConfigurationElement)configElement, (P)element, collection);
            }
        });
        this.collectionFinalizer.accept(collection);
        return collection;
    }
}

