/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.plugin.extensions;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.faktorips.datatype.Datatype;
import org.faktorips.devtools.model.internal.datatype.DatatypeDefinition;
import org.faktorips.devtools.model.plugin.ExtensionPoints;
import org.faktorips.devtools.model.plugin.extensions.LazyIntermediateCollectionExtension;

public class PredefinedDatatypesExtensions
extends LazyIntermediateCollectionExtension<DatatypeDefinition, Map<IConfigurationElement, Datatype>, Map<String, Datatype>> {
    public static final String EXTENSION_POINT_ID_DATATYPE_DEFINITION = "datatypeDefinition";
    public static final String EXTENSION_ATTRIBUTE_ID = "id";

    public PredefinedDatatypesExtensions(ExtensionPoints extensionPoints) {
        super(extensionPoints, EXTENSION_POINT_ID_DATATYPE_DEFINITION, "class", DatatypeDefinition.class, LinkedHashMap::new, PredefinedDatatypesExtensions::createDatatype, PredefinedDatatypesExtensions::sortByIpsAndOtherProviders);
    }

    @Override
    protected DatatypeDefinition create(IConfigurationElement configElement) {
        return new DatatypeDefinition((IExtension)configElement.getParent(), configElement);
    }

    private static void createDatatype(IConfigurationElement configElement, DatatypeDefinition datatypeDefinition, Map<IConfigurationElement, Datatype> datatypesByConfigElement) {
        if (datatypeDefinition.hasDatatype()) {
            Datatype datatype = datatypeDefinition.getDatatype();
            datatypesByConfigElement.put(configElement, datatype);
        }
    }

    private static Map<String, Datatype> sortByIpsAndOtherProviders(Map<IConfigurationElement, Datatype> datatypesByConfigElement) {
        LinkedHashMap<String, Datatype> datatypesByQualifiedName = new LinkedHashMap<String, Datatype>();
        PredefinedDatatypesExtensions.addAll(datatypesByConfigElement, datatypesByQualifiedName, Predicate.isEqual("org.faktorips.devtools.model"));
        PredefinedDatatypesExtensions.addAll(datatypesByConfigElement, datatypesByQualifiedName, Predicate.not(Predicate.isEqual("org.faktorips.devtools.model")));
        return datatypesByQualifiedName;
    }

    private static void addAll(Map<IConfigurationElement, Datatype> datatypesByConfigElement, Map<String, Datatype> datatypesByQualifiedName, Predicate<String> namespaceFilter) {
        datatypesByConfigElement.entrySet().stream().filter(e -> namespaceFilter.test(((IExtension)((IConfigurationElement)e.getKey()).getParent()).getNamespaceIdentifier())).map(Map.Entry::getValue).forEach(d -> {
            Datatype datatype = datatypesByQualifiedName.put(d.getQualifiedName(), (Datatype)d);
        });
    }
}

