/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.productcmpt;

import org.faktorips.devtools.model.internal.productcmpt.MultiValueHolder;
import org.faktorips.devtools.model.internal.productcmpt.SingleValueHolder;
import org.faktorips.devtools.model.productcmpt.IAttributeValue;
import org.faktorips.devtools.model.productcmpt.IAttributeValueHolderFactory;
import org.faktorips.devtools.model.productcmpt.IValueHolder;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeAttribute;
import org.faktorips.devtools.model.value.IValue;
import org.w3c.dom.Element;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum AttributeValueType {
    SINGLE_VALUE("SingleValue"){

        @Override
        public boolean isResponsibleFor(IProductCmptTypeAttribute attribute) {
            return !attribute.isMultiValueAttribute();
        }

        public Class<SingleValueHolder.Factory> getValueHolderFactory() {
            return SingleValueHolder.Factory.class;
        }
    }
    ,
    MULTI_VALUE("MultiValue"){

        @Override
        public boolean isResponsibleFor(IProductCmptTypeAttribute attribute) {
            return attribute.isMultiValueAttribute();
        }

        public Class<MultiValueHolder.Factory> getValueHolderFactory() {
            return MultiValueHolder.Factory.class;
        }
    };

    private final String xmlTypeName;

    private <T> AttributeValueType(String xmlTypeName) {
        this.xmlTypeName = xmlTypeName;
    }

    public String getXmlTypeName() {
        return this.xmlTypeName;
    }

    public abstract <T> Class<? extends IAttributeValueHolderFactory<T>> getValueHolderFactory();

    public <T> IValueHolder<T> newHolderInstance(IAttributeValue attributeValue) {
        try {
            Class<IAttributeValueHolderFactory<T>> valueHolderFactory = this.getValueHolderFactory();
            IAttributeValueHolderFactory<T> factory = valueHolderFactory.getConstructor(new Class[0]).newInstance(new Object[0]);
            return factory.createValueHolder(attributeValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> IValueHolder<T> newHolderInstance(IAttributeValue attributeValue, IValue<?> defaultValue) {
        try {
            Class<IAttributeValueHolderFactory<T>> valueHolderFactory = this.getValueHolderFactory();
            IAttributeValueHolderFactory<T> factory = valueHolderFactory.getConstructor(new Class[0]).newInstance(new Object[0]);
            return factory.createValueHolder(attributeValue, defaultValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public abstract boolean isResponsibleFor(IProductCmptTypeAttribute var1);

    public static AttributeValueType getType(Element valueEl) {
        String valueType = valueEl == null ? null : valueEl.getAttribute("valueType");
        return AttributeValueType.getType(valueType);
    }

    public static AttributeValueType getType(String typeName) {
        AttributeValueType[] attributeValueTypeArray = AttributeValueType.values();
        int n = attributeValueTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeValueType type = attributeValueTypeArray[n2];
            if (type.xmlTypeName.equals(typeName)) {
                return type;
            }
            ++n2;
        }
        return SINGLE_VALUE;
    }

    public static AttributeValueType getTypeFor(IProductCmptTypeAttribute attribute) {
        if (attribute != null) {
            AttributeValueType[] attributeValueTypeArray = AttributeValueType.values();
            int n = attributeValueTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                AttributeValueType type = attributeValueTypeArray[n2];
                if (type.isResponsibleFor(attribute)) {
                    return type;
                }
                ++n2;
            }
        }
        return SINGLE_VALUE;
    }
}

