/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.productcmpt;

import java.text.MessageFormat;
import java.util.Objects;
import org.faktorips.devtools.model.productcmpt.IProductCmptLink;
import org.faktorips.devtools.model.productcmpt.Messages;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.util.StringUtil;

public class Cardinality
implements Comparable<Cardinality> {
    public static final int CARDINALITY_MANY = Integer.MAX_VALUE;
    public static final Cardinality UNDEFINED = new UndefinedCardinality();
    public static final String MSGCODE_DEFAULT_CARDINALITY_OUT_OF_RANGE = "PRODUCTCMPT_RELATION-DefaultCardinalityOutOfRange";
    public static final String MSGCODE_MAX_CARDINALITY_IS_LESS_THAN_MIN = "PRODUCTCMPT_RELATION-MaxCardinalityIsLessThanMin";
    public static final String MSGCODE_MAX_CARDINALITY_IS_LESS_THAN_1 = "PRODUCTCMPT_RELATION-MaxCardinalityIsLessThan1";
    public static final String MSGCODE_MIN_CARDINALITY_IS_LESS_THAN_0 = "PRODUCTCMPT_RELATION-MinCardinalityIsLessThan0";
    private final int min;
    private final int max;
    private final int defaultCard;

    public Cardinality(int min, int max, int defaultCard) {
        this.min = min;
        this.max = max;
        this.defaultCard = defaultCard;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public boolean isToMany() {
        return this.max == Integer.MAX_VALUE;
    }

    public int getDefault() {
        return this.defaultCard;
    }

    public Cardinality withMin(int newMin) {
        return new Cardinality(newMin, this.max, this.defaultCard);
    }

    public Cardinality withMax(int newMax) {
        return new Cardinality(this.min, newMax, this.defaultCard);
    }

    public Cardinality withDefault(int newDefault) {
        return new Cardinality(this.min, this.max, newDefault);
    }

    public MessageList validate(IProductCmptLink link) {
        MessageList result = new MessageList();
        if (this.min < 0) {
            String text = Messages.ProductCmptRelation_msgMinCardinalityIsLessThan0;
            result.add(new Message(MSGCODE_MIN_CARDINALITY_IS_LESS_THAN_0, text, Message.ERROR, (Object)link, new String[]{"minCardinality"}));
        } else if (this.max < 1) {
            String text = Messages.ProductCmptRelation_msgMaxCardinalityIsLessThan1;
            result.add(new Message(MSGCODE_MAX_CARDINALITY_IS_LESS_THAN_1, text, Message.ERROR, (Object)link, new String[]{"maxCardinality"}));
        } else if (this.min > this.max) {
            String text = Messages.ProductCmptRelation_msgMaxCardinalityIsLessThanMin;
            result.add(new Message(MSGCODE_MAX_CARDINALITY_IS_LESS_THAN_MIN, text, Message.ERROR, (Object)link, new String[]{"minCardinality", "maxCardinality"}));
        } else if (this.defaultCard > this.max || this.min > this.defaultCard || this.defaultCard == Integer.MAX_VALUE) {
            String text = MessageFormat.format(Messages.ProductCmptLink_msgDefaultCardinalityOutOfRange, Integer.toString(this.min), this.isToMany() ? "*" : Integer.toString(this.max));
            result.add(new Message(MSGCODE_DEFAULT_CARDINALITY_OUT_OF_RANGE, text, Message.ERROR, (Object)link, new String[]{"defaultCardinality"}));
        }
        return result;
    }

    public String format() {
        return StringUtil.getRangeString((int)this.min, (int)this.max, (int)this.defaultCard);
    }

    public int hashCode() {
        return Objects.hash(this.defaultCard, this.max, this.min);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Cardinality other = (Cardinality)obj;
        return this.defaultCard == other.defaultCard && this.max == other.max && this.min == other.min;
    }

    public String toString() {
        return this.format();
    }

    @Override
    public int compareTo(Cardinality o) {
        if (o == null || o instanceof UndefinedCardinality) {
            return -1;
        }
        if (this.min != o.min) {
            return Integer.compare(this.min, o.min);
        }
        if (this.max != o.max) {
            return Integer.compare(this.max, o.max);
        }
        return Integer.compare(this.defaultCard, o.defaultCard);
    }

    private static class UndefinedCardinality
    extends Cardinality {
        private UndefinedCardinality() {
            super(0, 0, 0);
        }

        @Override
        public MessageList validate(IProductCmptLink link) {
            return new MessageList();
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof UndefinedCardinality;
        }

        @Override
        public int compareTo(Cardinality o) {
            if (o == null) {
                return -1;
            }
            if (o instanceof UndefinedCardinality) {
                return 0;
            }
            return 1;
        }
    }
}

