/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.productcmpt;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.faktorips.devtools.model.internal.productcmpt.AbstractProductCmptNamingStrategy;
import org.faktorips.devtools.model.internal.productcmpt.Messages;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.runtime.Message;
import org.faktorips.runtime.MessageList;
import org.faktorips.util.ArgumentCheck;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DateBasedProductCmptNamingStrategy
extends AbstractProductCmptNamingStrategy {
    public static final String EXTENSION_ID = "org.faktorips.devtools.model.DateBasedProductCmptNamingStrategy";
    public static final String XML_TAG_NAME = "DateBasedProductCmptNamingStrategy";
    private String dateFormatPattern;
    private DateFormat dateFormat;
    private boolean postfixAllowed;

    public DateBasedProductCmptNamingStrategy() {
    }

    public DateBasedProductCmptNamingStrategy(String separator, String dateFormatPattern, boolean allowPostfix) {
        super(separator);
        this.setDateFormatPattern(dateFormatPattern);
        this.postfixAllowed = allowPostfix;
    }

    @Override
    public String getExtensionId() {
        return EXTENSION_ID;
    }

    @Override
    public boolean supportsVersionId() {
        return true;
    }

    public void setDateFormatPattern(String pattern) {
        ArgumentCheck.notNull((Object)pattern);
        this.dateFormatPattern = pattern;
        this.dateFormat = new SimpleDateFormat(pattern, Locale.getDefault());
        this.dateFormat.setLenient(false);
    }

    public String getDateFormatPattern() {
        return this.dateFormatPattern;
    }

    public void setPostfixAllowed(boolean flag) {
        this.postfixAllowed = flag;
    }

    public boolean isPostfixAllowed() {
        return this.postfixAllowed;
    }

    @Override
    public MessageList validateVersionId(String versionId) {
        MessageList list = new MessageList();
        String id = versionId;
        if (id.length() < this.dateFormatPattern.length()) {
            list.add(this.newInvalidVersionIdMsg());
            return list;
        }
        if (this.postfixAllowed) {
            id = id.substring(0, this.dateFormatPattern.length());
        }
        try {
            this.dateFormat.parse(id);
            if (id.length() != this.dateFormatPattern.length()) {
                throw new RuntimeException();
            }
        }
        catch (Exception e) {
            list.add(this.newInvalidVersionIdMsg());
        }
        return list;
    }

    private Message newInvalidVersionIdMsg() {
        String versionConcept = this.getIpsProject().getChangesInTimeNamingConventionForGeneratedCode().getVersionConceptNameSingular();
        String text = MessageFormat.format(Messages.DateBasedProductCmptNamingStrategy_msgWrongFormat, versionConcept, this.dateFormatPattern);
        return Message.newError((String)"ProductCmptNamingStrategy-IllegalVersionId", (String)text);
    }

    @Override
    public String getNextVersionId(IProductCmpt pc, GregorianCalendar validFrom) {
        return this.dateFormat.format(validFrom.getTime());
    }

    @Override
    public void initSubclassFromXml(Element el) {
        this.setDateFormatPattern(el.getAttribute("dateFormatPattern"));
        this.postfixAllowed = Boolean.parseBoolean(el.getAttribute("postfixAllowed"));
    }

    @Override
    public Element toXmlSubclass(Document doc) {
        Element el = doc.createElement(XML_TAG_NAME);
        el.setAttribute("dateFormatPattern", this.dateFormatPattern);
        el.setAttribute("postfixAllowed", "" + this.postfixAllowed);
        return el;
    }

    @Override
    public String getUniqueRuntimeId(IIpsProject project, String productCmptName) {
        String id;
        String uniqueId = id = String.valueOf(project.getRuntimeIdPrefix()) + productCmptName;
        String kindId = this.getKindId(uniqueId);
        String versionId = this.getVersionId(uniqueId);
        int i = 1;
        while (project.findProductCmptByRuntimeId(uniqueId) != null) {
            uniqueId = String.valueOf(kindId) + i + this.getVersionIdSeparator() + versionId;
            ++i;
        }
        return uniqueId;
    }
}

