/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.productcmpt;

import java.text.MessageFormat;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.productcmpt.Messages;

public enum DeltaType {
    MISSING_PROPERTY_VALUE(Messages.DeltaType_missingValue, Kind.ADD),
    VALUE_WITHOUT_PROPERTY(Messages.DeltaType_propertiesNotFoundInTheModel, Kind.DELETE),
    PROPERTY_TYPE_MISMATCH(Messages.DeltaType_propertiesWithTypeMismatch, Kind.MODIFY),
    HIDDEN_ATTRIBUTE_MISMATCH(Messages.DeltaType_hiddenAttributeMismatch, Kind.MODIFY),
    VALUE_SET_MISMATCH(Messages.DeltaType_ValueSetMismatches, Kind.MODIFY),
    VALUE_HOLDER_MISMATCH(Messages.DeltaType_valueHolderMismatch, Kind.MODIFY),
    MULTILINGUAL_MISMATCH(Messages.DeltaType_multilingualMismatch, Kind.MODIFY),
    LINK_WITHOUT_ASSOCIATION(Messages.DeltaType_LinksNotFoundInTheModel, Kind.DELETE),
    LINK_CHANGING_OVER_TIME_MISMATCH(Messages.DeltaType_LinksWithWrongParent, Kind.MODIFY),
    LINK_TARGET_RUNTIME_ID_MISMATCH(Messages.DeltaType_LinksWithWrongTargetRuntimeId, Kind.MODIFY),
    MISSING_TEMPLATE_LINK(Messages.DeltaType_missingTemplateLink, Kind.ADD),
    REMOVED_TEMPLATE_LINK(Messages.DeltaType_removedTemplateLink, Kind.DELETE),
    INVALID_GENERATIONS(MessageFormat.format(Messages.DeltaType_invalidGenerations, IIpsModelExtensions.get().getModelPreferences().getChangesOverTimeNamingConvention().getGenerationConceptNamePlural(true)), Kind.DELETE),
    DATATYPE_MISMATCH(Messages.DeltaType_datatypeMissmatch, Kind.MODIFY),
    INHERITED_TEMPLATE_MISMATCH(Messages.DeltaType_InheritedTemplateMismatch, Kind.MODIFY),
    INHERITED_UNDEFINED_TEMPLATE_MISMATCH(Messages.DeltaType_InheritedUndefinedTemplateMismatch, Kind.MODIFY);

    private final String description;
    private final Kind kind;

    private DeltaType(String description, Kind kind) {
        this.description = description;
        this.kind = kind;
    }

    public String getDescription() {
        return this.description;
    }

    public Kind getKind() {
        return this.kind;
    }

    public static enum Kind {
        ADD,
        DELETE,
        MODIFY;

    }
}

