/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.productcmpt;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.faktorips.devtools.model.productcmpt.ISingleValueHolder;
import org.faktorips.devtools.model.productcmpt.IValueHolder;
import org.faktorips.devtools.model.value.IValue;
import org.faktorips.util.collections.ListComparator;

public interface IMultiValueHolder
extends IValueHolder<List<ISingleValueHolder>> {
    public static final String SEPARATOR = "|";
    public static final String XML_TYPE_NAME = "MultiValue";
    public static final String MSGCODE_PREFIX = "MULTIVALUEHOLDER-";
    public static final String MSGCODE_CONTAINS_INVALID_VALUE = "MULTIVALUEHOLDER-ContainsInvalidValue";
    public static final String MSGCODE_CONTAINS_DUPLICATE_VALUE = "MULTIVALUEHOLDER-ContainsDuplicateValue";

    @Override
    default public List<IValue<?>> getValueList() {
        return ((List)this.getValue()).stream().map(IValueHolder::getValue).collect(Collectors.toList());
    }

    @Override
    default public int compareTo(IValueHolder<List<ISingleValueHolder>> o) {
        if (o == null) {
            return 1;
        }
        Comparator naturalComparator = Comparator.naturalOrder();
        return ListComparator.listComparator(naturalComparator).compare((List)this.getValue(), o.getValue());
    }

    @Override
    default public String getStringValue() {
        ArrayList<String> stringList = new ArrayList<String>();
        for (ISingleValueHolder holder : (List)this.getValue()) {
            stringList.add(holder.getStringValue());
        }
        return ((Object)stringList).toString();
    }

    @Override
    default public boolean isNullValue() {
        return false;
    }

    @Override
    default public boolean isMultiValue() {
        return true;
    }
}

