/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.productcmpt;

import java.util.Objects;
import java.util.function.Function;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.ipsobject.IDescribedElement;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.Cardinality;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.productcmpt.IProductCmptLinkContainer;
import org.faktorips.devtools.model.productcmpt.template.ITemplatedValue;
import org.faktorips.devtools.model.productcmpt.template.ITemplatedValueContainer;
import org.faktorips.devtools.model.productcmpt.template.ITemplatedValueIdentifier;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeAssociation;
import org.faktorips.devtools.model.type.IAssociation;
import org.faktorips.util.ArgumentCheck;

public interface IProductCmptLink
extends IDescribedElement,
ITemplatedValue {
    public static final String PROPERTY_TARGET = "target";
    public static final String PROPERTY_TARGET_RUNTIME_ID = "targetRuntimeId";
    public static final String PROPERTY_ASSOCIATION = "association";
    public static final String PROPERTY_CARDINALITY = "cardinality";
    public static final String PROPERTY_MIN_CARDINALITY = "minCardinality";
    public static final String PROPERTY_DEFAULT_CARDINALITY = "defaultCardinality";
    public static final String PROPERTY_MAX_CARDINALITY = "maxCardinality";
    public static final String TAG_NAME = "Link";
    public static final String MSGCODE_PREFIX = "PRODUCTCMPT_RELATION-";
    public static final String MSGCODE_UNKNWON_ASSOCIATION = "PRODUCTCMPT_RELATION-UnknownAssociation";
    public static final String MSGCODE_UNKNWON_TARGET = "PRODUCTCMPT_RELATION-UnknownTarget";
    public static final String MSGCODE_MISSING_MAX_CARDINALITY = "PRODUCTCMPT_RELATION-MissingMaxCardinality";
    public static final String MSGCODE_MAX_CARDINALITY_EXCEEDS_MODEL_MAX = "PRODUCTCMPT_RELATION-MaxCardinalityExceedsModelMax";
    public static final String MSGCODE_MIN_CARDINALITY_FALLS_BELOW_MODEL_MIN = "PRODUCTCMPT_RELATION-MinCardinalityFallsBelowModelMin";
    public static final String MSGCODE_INVALID_TARGET = "PRODUCTCMPT_RELATION-InvalidTarget";
    public static final String MSGCODE_CHANGING_OVER_TIME_MISMATCH = "PRODUCTCMPT_RELATION-ChangingOverTimeMismatch";

    public IProductCmpt getProductCmpt();

    public IProductCmptLinkContainer getProductCmptLinkContainer();

    public String getAssociation();

    public void setAssociation(String var1);

    public IProductCmptTypeAssociation findAssociation(IIpsProject var1) throws IpsException;

    public String getTarget();

    public void setTarget(String var1);

    public IProductCmpt findTarget(IIpsProject var1) throws IpsException;

    public String getTargetRuntimeId();

    public void setTargetRuntimeId(String var1);

    public Cardinality getCardinality();

    public void setCardinality(Cardinality var1);

    public int getMinCardinality();

    public void setMinCardinality(int var1);

    public int getDefaultCardinality();

    public void setDefaultCardinality(int var1);

    public int getMaxCardinality();

    public void setMaxCardinality(int var1);

    public boolean constrainsPolicyCmptTypeAssociation(IIpsProject var1);

    public boolean isMandatory();

    public boolean isOptional();

    public boolean is1ToMany();

    public boolean isLinkOfAssociation(IAssociation var1, IIpsProject var2) throws IpsException;

    public boolean isConfiguringPolicyAssociation();

    @Override
    public IProductCmptLink findTemplateProperty(IIpsProject var1);

    public Function<IProductCmptLink, Object> getValueGetter();

    public Function<IProductCmptLink, Object> getInternalValueGetter();

    public static class LinkIdentifier
    implements ITemplatedValueIdentifier {
        private final String association;
        private final String target;

        public LinkIdentifier(String association, String target) {
            this.association = Objects.requireNonNull(association);
            this.target = Objects.requireNonNull(target);
        }

        public LinkIdentifier(IProductCmptLink link) {
            this(link.getAssociation(), link.getTarget());
        }

        public String getAssociation() {
            return this.association;
        }

        public String getTarget() {
            return this.target;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.association.hashCode();
            return 31 * result + this.target.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            LinkIdentifier other = (LinkIdentifier)obj;
            return Objects.equals(this.association, other.association) && Objects.equals(this.target, other.target);
        }

        @Override
        public IProductCmptLink getValueFrom(ITemplatedValueContainer container) {
            ArgumentCheck.isInstanceOf((Object)container, IProductCmptLinkContainer.class);
            IProductCmptLinkContainer linkContainer = (IProductCmptLinkContainer)container;
            for (IProductCmptLink link : linkContainer.getLinksAsList(this.association)) {
                if (!Objects.equals(this.target, link.getTarget())) continue;
                return link;
            }
            return null;
        }
    }
}

