/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.productcmpt;

import java.util.Objects;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.IPropertyValueContainer;
import org.faktorips.devtools.model.productcmpt.PropertyValueType;
import org.faktorips.devtools.model.productcmpt.template.ITemplatedValue;
import org.faktorips.devtools.model.productcmpt.template.ITemplatedValueContainer;
import org.faktorips.devtools.model.productcmpt.template.ITemplatedValueIdentifier;
import org.faktorips.devtools.model.type.IProductCmptProperty;
import org.faktorips.devtools.model.type.ProductCmptPropertyType;
import org.faktorips.util.ArgumentCheck;

public interface IPropertyValue
extends ITemplatedValue {
    public static final String MSGCODE_PREFIX = "PROPERTYVALUE-";

    public String getPropertyName();

    public IProductCmptProperty findProperty(IIpsProject var1) throws IpsException;

    public PropertyValueType getPropertyValueType();

    public ProductCmptPropertyType getProductCmptPropertyType();

    public Object getPropertyValue();

    public IPropertyValueContainer getPropertyValueContainer();

    @Override
    public IPropertyValue findTemplateProperty(IIpsProject var1);

    public static class PropertyValueIdentifier
    implements ITemplatedValueIdentifier {
        private final String propertyName;
        private final PropertyValueType type;

        public PropertyValueIdentifier(String propertyName, PropertyValueType type) {
            this.propertyName = Objects.requireNonNull(propertyName);
            this.type = type;
        }

        public PropertyValueIdentifier(IPropertyValue p) {
            this(p.getPropertyName(), p.getPropertyValueType());
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.propertyName, this.type});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PropertyValueIdentifier other = (PropertyValueIdentifier)obj;
            return Objects.equals(this.propertyName, other.propertyName) && this.type == other.type;
        }

        @Override
        public IPropertyValue getValueFrom(ITemplatedValueContainer container) {
            ArgumentCheck.isInstanceOf((Object)container, IPropertyValueContainer.class);
            IPropertyValueContainer propertyValueContainer = (IPropertyValueContainer)container;
            return propertyValueContainer.getPropertyValue(this.propertyName, this.type.getInterfaceClass());
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public PropertyValueType getType() {
            return this.type;
        }
    }
}

