/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.productcmpt;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.faktorips.datatype.Datatype;
import org.faktorips.devtools.model.internal.ipsobject.IpsObjectPart;
import org.faktorips.devtools.model.internal.productcmpt.AttributeValue;
import org.faktorips.devtools.model.internal.productcmpt.ConfiguredDefault;
import org.faktorips.devtools.model.internal.productcmpt.ConfiguredValueSet;
import org.faktorips.devtools.model.internal.productcmpt.Formula;
import org.faktorips.devtools.model.internal.productcmpt.TableContentUsage;
import org.faktorips.devtools.model.internal.productcmpt.ValidationRuleConfig;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPart;
import org.faktorips.devtools.model.ipsobject.IIpsObjectPartContainer;
import org.faktorips.devtools.model.pctype.IPolicyCmptTypeAttribute;
import org.faktorips.devtools.model.pctype.IValidationRule;
import org.faktorips.devtools.model.productcmpt.AttributeValueType;
import org.faktorips.devtools.model.productcmpt.IAttributeValue;
import org.faktorips.devtools.model.productcmpt.IConfiguredDefault;
import org.faktorips.devtools.model.productcmpt.IConfiguredValueSet;
import org.faktorips.devtools.model.productcmpt.IFormula;
import org.faktorips.devtools.model.productcmpt.IPropertyValue;
import org.faktorips.devtools.model.productcmpt.IPropertyValueContainer;
import org.faktorips.devtools.model.productcmpt.ITableContentUsage;
import org.faktorips.devtools.model.productcmpt.IValidationRuleConfig;
import org.faktorips.devtools.model.productcmpt.IValueHolder;
import org.faktorips.devtools.model.productcmpttype.IProductCmptTypeAttribute;
import org.faktorips.devtools.model.type.IProductCmptProperty;
import org.faktorips.devtools.model.type.ProductCmptPropertyType;
import org.faktorips.devtools.model.util.NullSafeComparableComparator;
import org.faktorips.devtools.model.value.IValue;
import org.faktorips.devtools.model.value.ValueFactory;
import org.faktorips.devtools.model.valueset.IValueSet;
import org.faktorips.devtools.model.valueset.IValueSetOwner;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum PropertyValueType {
    ATTRIBUTE_VALUE(IAttributeValue.class, AttributeValue.class, "AttributeValue"){

        @Override
        public IAttributeValue createPropertyValue(IPropertyValueContainer container, IProductCmptProperty property, String partId) {
            AttributeValue attributeValue = new AttributeValue(container, partId, property == null ? "" : property.getPropertyName());
            IProductCmptTypeAttribute attribute = (IProductCmptTypeAttribute)property;
            IValue<String> defaultValue = attribute != null ? ValueFactory.createValue(attribute.isMultilingual(), attribute.getDefaultValue()) : ValueFactory.createStringValue(null);
            AttributeValueType attributeValueType = AttributeValueType.getTypeFor(attribute);
            IValueHolder valueHolder = attributeValueType.newHolderInstance(attributeValue, defaultValue);
            attributeValue.setValueHolderInternal(valueHolder);
            return attributeValue;
        }

        @Override
        public Function<IPropertyValue, Object> getValueGetter() {
            return propertyValue -> {
                IPropertyValue iPropertyValue = propertyValue;
                if (iPropertyValue instanceof IAttributeValue) {
                    void attributeValue;
                    IAttributeValue iAttributeValue = (IAttributeValue)iPropertyValue;
                    IAttributeValue cfr_ignored_0 = (IAttributeValue)iPropertyValue;
                    return attributeValue.getValueHolder();
                }
                throw new IllegalArgumentException("Illegal parameter " + propertyValue);
            };
        }

        @Override
        public Function<IPropertyValue, Object> getInternalValueGetter() {
            return propertyValue -> {
                IPropertyValue iPropertyValue = propertyValue;
                if (iPropertyValue instanceof AttributeValue) {
                    void attributeValue;
                    AttributeValue attributeValue2 = (AttributeValue)iPropertyValue;
                    AttributeValue cfr_ignored_0 = (AttributeValue)iPropertyValue;
                    return attributeValue.getValueHolderInternal();
                }
                throw new IllegalArgumentException("Illegal parameter " + propertyValue);
            };
        }

        @Override
        public ProductCmptPropertyType getCorrespondingPropertyType() {
            return ProductCmptPropertyType.PRODUCT_CMPT_TYPE_ATTRIBUTE;
        }

        @Override
        public BiConsumer<IPropertyValue, Object> getValueSetter() {
            return (propertyValue, value) -> {
                void attributeValue;
                IPropertyValue iPropertyValue;
                if (!(value instanceof IValueHolder) || !((iPropertyValue = propertyValue) instanceof IAttributeValue)) {
                    throw new IllegalArgumentException();
                }
                IAttributeValue iAttributeValue = (IAttributeValue)iPropertyValue;
                IAttributeValue cfr_ignored_0 = (IAttributeValue)iPropertyValue;
                attributeValue.setValueHolder(((IValueHolder)value).copy((IAttributeValue)attributeValue));
            };
        }

        @Override
        public boolean isPartOfComposite() {
            return false;
        }

        @Override
        public Function<Object, String> getValueToString() {
            return o -> {
                String string;
                Object object = o;
                if (object instanceof IValueHolder) {
                    void valueHolder;
                    IValueHolder iValueHolder = (IValueHolder)object;
                    IValueHolder cfr_ignored_0 = (IValueHolder)object;
                    string = valueHolder.getStringValue();
                } else {
                    string = Objects.toString(o);
                }
                return string;
            };
        }
    }
    ,
    TABLE_CONTENT_USAGE(ITableContentUsage.class, TableContentUsage.class, "TableContentUsage"){

        @Override
        public ITableContentUsage createPropertyValue(IPropertyValueContainer container, IProductCmptProperty property, String partId) {
            return new TableContentUsage(container, partId, property == null ? "" : property.getPropertyName());
        }

        @Override
        public Function<IPropertyValue, Object> getValueGetter() {
            return propertyValue -> {
                IPropertyValue iPropertyValue = propertyValue;
                if (iPropertyValue instanceof ITableContentUsage) {
                    void contentUsage;
                    ITableContentUsage iTableContentUsage = (ITableContentUsage)iPropertyValue;
                    ITableContentUsage cfr_ignored_0 = (ITableContentUsage)iPropertyValue;
                    return contentUsage.getTableContentName();
                }
                throw new IllegalArgumentException("Illegal parameter " + propertyValue);
            };
        }

        @Override
        public Function<IPropertyValue, Object> getInternalValueGetter() {
            return propertyValue -> {
                IPropertyValue iPropertyValue = propertyValue;
                if (iPropertyValue instanceof TableContentUsage) {
                    void contentUsage;
                    TableContentUsage tableContentUsage = (TableContentUsage)iPropertyValue;
                    TableContentUsage cfr_ignored_0 = (TableContentUsage)iPropertyValue;
                    return contentUsage.getInternalTableContentName();
                }
                throw new IllegalArgumentException("Illegal parameter " + propertyValue);
            };
        }

        @Override
        public ProductCmptPropertyType getCorrespondingPropertyType() {
            return ProductCmptPropertyType.TABLE_STRUCTURE_USAGE;
        }

        @Override
        public BiConsumer<IPropertyValue, Object> getValueSetter() {
            return (propertyValue, value) -> {
                void element;
                IPropertyValue iPropertyValue;
                if (value != null && !(value instanceof String) || !((iPropertyValue = propertyValue) instanceof ITableContentUsage)) {
                    throw new IllegalArgumentException();
                }
                ITableContentUsage iTableContentUsage = (ITableContentUsage)iPropertyValue;
                ITableContentUsage cfr_ignored_0 = (ITableContentUsage)iPropertyValue;
                element.setTableContentName((String)value);
            };
        }

        @Override
        public boolean isPartOfComposite() {
            return false;
        }
    }
    ,
    FORMULA(IFormula.class, Formula.class, "Formula"){

        @Override
        public IFormula createPropertyValue(IPropertyValueContainer container, IProductCmptProperty property, String partId) {
            return new Formula(container, partId, property == null ? "" : property.getPropertyName());
        }

        @Override
        public Function<IPropertyValue, Object> getValueGetter() {
            return propertyValue -> {
                IPropertyValue iPropertyValue = propertyValue;
                if (iPropertyValue instanceof IFormula) {
                    void formula;
                    IFormula iFormula = (IFormula)iPropertyValue;
                    IFormula cfr_ignored_0 = (IFormula)iPropertyValue;
                    return formula.getExpression();
                }
                throw new IllegalArgumentException("Illegal parameter " + propertyValue);
            };
        }

        @Override
        public Function<IPropertyValue, Object> getInternalValueGetter() {
            return propertyValue -> {
                IPropertyValue iPropertyValue = propertyValue;
                if (iPropertyValue instanceof Formula) {
                    void formula;
                    Formula formula2 = (Formula)iPropertyValue;
                    Formula cfr_ignored_0 = (Formula)iPropertyValue;
                    return formula.getExpressionInternal();
                }
                throw new IllegalArgumentException("Illegal parameter " + propertyValue);
            };
        }

        @Override
        public ProductCmptPropertyType getCorrespondingPropertyType() {
            return ProductCmptPropertyType.FORMULA_SIGNATURE_DEFINITION;
        }

        @Override
        public BiConsumer<IPropertyValue, Object> getValueSetter() {
            return (propertyValue, value) -> {
                void element;
                IPropertyValue iPropertyValue;
                if (value != null && !(value instanceof String) || !((iPropertyValue = propertyValue) instanceof IFormula)) {
                    throw new IllegalArgumentException();
                }
                IFormula iFormula = (IFormula)iPropertyValue;
                IFormula cfr_ignored_0 = (IFormula)iPropertyValue;
                element.setExpression((String)value);
            };
        }

        @Override
        public boolean isPartOfComposite() {
            return false;
        }
    }
    ,
    CONFIGURED_VALUESET(IConfiguredValueSet.class, ConfiguredValueSet.class, "ConfiguredValueSet"){

        @Override
        public IConfiguredValueSet createPropertyValue(IPropertyValueContainer container, IProductCmptProperty property, String partId) {
            String policyAttributeName = property != null ? property.getName() : "";
            ConfiguredValueSet configuredValueSet = new ConfiguredValueSet(container, policyAttributeName, partId);
            IPolicyCmptTypeAttribute attribute = (IPolicyCmptTypeAttribute)property;
            if (attribute != null) {
                configuredValueSet.setValueSetCopy(attribute.getValueSet());
                if (Datatype.BOOLEAN.getQualifiedName().equals(attribute.getDatatype()) || Datatype.PRIMITIVE_BOOLEAN.getQualifiedName().equals(attribute.getDatatype())) {
                    configuredValueSet.convertValueSetToEnumType();
                }
            }
            return configuredValueSet;
        }

        @Override
        public Function<IPropertyValue, Object> getValueGetter() {
            return propertyValue -> {
                IPropertyValue iPropertyValue = propertyValue;
                if (iPropertyValue instanceof IConfiguredValueSet) {
                    void configuredValueSet;
                    IConfiguredValueSet iConfiguredValueSet = (IConfiguredValueSet)iPropertyValue;
                    IConfiguredValueSet cfr_ignored_0 = (IConfiguredValueSet)iPropertyValue;
                    return configuredValueSet.getValueSet();
                }
                throw new IllegalArgumentException("Illegal parameter " + propertyValue);
            };
        }

        @Override
        public Function<IPropertyValue, Object> getInternalValueGetter() {
            return propertyValue -> {
                IPropertyValue iPropertyValue = propertyValue;
                if (iPropertyValue instanceof ConfiguredValueSet) {
                    void configuredValueSet;
                    ConfiguredValueSet configuredValueSet2 = (ConfiguredValueSet)iPropertyValue;
                    ConfiguredValueSet cfr_ignored_0 = (ConfiguredValueSet)iPropertyValue;
                    return configuredValueSet.getValueSetInternal();
                }
                throw new IllegalArgumentException("Illegal parameter " + propertyValue);
            };
        }

        @Override
        public ProductCmptPropertyType getCorrespondingPropertyType() {
            return ProductCmptPropertyType.POLICY_CMPT_TYPE_ATTRIBUTE;
        }

        @Override
        public <T> Comparator<T> getValueComparator() {
            return new ValueSetComparator();
        }

        @Override
        public BiConsumer<IPropertyValue, Object> getValueSetter() {
            return (propertyValue, value) -> {
                void element;
                IPropertyValue iPropertyValue;
                if (!(value instanceof IValueSet) || !((iPropertyValue = propertyValue) instanceof IConfiguredValueSet)) {
                    throw new IllegalArgumentException();
                }
                IConfiguredValueSet iConfiguredValueSet = (IConfiguredValueSet)iPropertyValue;
                IConfiguredValueSet cfr_ignored_0 = (IConfiguredValueSet)iPropertyValue;
                element.setValueSet(((IValueSet)value).copy((IValueSetOwner)element, element.getIpsModel().getNextPartId((IIpsObjectPartContainer)element)));
            };
        }

        @Override
        public Function<Object, String> getValueToString() {
            return o -> {
                String string;
                Object object = o;
                if (object instanceof IValueSet) {
                    void valueSet;
                    IValueSet iValueSet = (IValueSet)object;
                    IValueSet cfr_ignored_0 = (IValueSet)object;
                    string = valueSet.toShortString();
                } else {
                    string = Objects.toString(o);
                }
                return string;
            };
        }

        @Override
        public boolean isPartOfComposite() {
            return true;
        }

        @Override
        protected boolean isProperXmlTagName(String xmlTagName) {
            return super.isProperXmlTagName(xmlTagName) || "ValueSet".equals(xmlTagName);
        }
    }
    ,
    CONFIGURED_DEFAULT(IConfiguredDefault.class, ConfiguredDefault.class, "ConfiguredDefault"){

        @Override
        public IConfiguredDefault createPropertyValue(IPropertyValueContainer container, IProductCmptProperty property, String partId) {
            String policyAttributeName = property != null ? property.getName() : "";
            ConfiguredDefault configuredDefault = new ConfiguredDefault(container, policyAttributeName, partId);
            IPolicyCmptTypeAttribute attribute = (IPolicyCmptTypeAttribute)property;
            if (attribute != null) {
                configuredDefault.setValue(attribute.getDefaultValue());
            }
            return configuredDefault;
        }

        @Override
        public Function<IPropertyValue, Object> getValueGetter() {
            return propertyValue -> {
                IPropertyValue iPropertyValue = propertyValue;
                if (iPropertyValue instanceof IConfiguredDefault) {
                    void configuredDefault;
                    IConfiguredDefault iConfiguredDefault = (IConfiguredDefault)iPropertyValue;
                    IConfiguredDefault cfr_ignored_0 = (IConfiguredDefault)iPropertyValue;
                    return configuredDefault.getValue();
                }
                throw new IllegalArgumentException("Illegal parameter " + propertyValue);
            };
        }

        @Override
        public Function<IPropertyValue, Object> getInternalValueGetter() {
            return propertyValue -> {
                IPropertyValue iPropertyValue = propertyValue;
                if (iPropertyValue instanceof ConfiguredDefault) {
                    void configuredDefault;
                    ConfiguredDefault configuredDefault2 = (ConfiguredDefault)iPropertyValue;
                    ConfiguredDefault cfr_ignored_0 = (ConfiguredDefault)iPropertyValue;
                    return configuredDefault.getValueInternal();
                }
                throw new IllegalArgumentException("Illegal parameter " + propertyValue);
            };
        }

        @Override
        public ProductCmptPropertyType getCorrespondingPropertyType() {
            return ProductCmptPropertyType.POLICY_CMPT_TYPE_ATTRIBUTE;
        }

        @Override
        public BiConsumer<IPropertyValue, Object> getValueSetter() {
            return (propertyValue, value) -> {
                void element;
                IPropertyValue iPropertyValue;
                if (value != null && !(value instanceof String) || !((iPropertyValue = propertyValue) instanceof IConfiguredDefault)) {
                    throw new IllegalArgumentException();
                }
                IConfiguredDefault iConfiguredDefault = (IConfiguredDefault)iPropertyValue;
                IConfiguredDefault cfr_ignored_0 = (IConfiguredDefault)iPropertyValue;
                element.setValue((String)value);
            };
        }

        @Override
        public boolean isPartOfComposite() {
            return true;
        }

        @Override
        protected boolean isProperXmlTagName(String xmlTagName) {
            return super.isProperXmlTagName(xmlTagName) || "Value".equals(xmlTagName);
        }
    }
    ,
    VALIDATION_RULE_CONFIG(IValidationRuleConfig.class, ValidationRuleConfig.class, "ValidationRuleConfig"){

        @Override
        public IValidationRuleConfig createPropertyValue(IPropertyValueContainer container, IProductCmptProperty property, String partId) {
            ValidationRuleConfig ruleConfig = new ValidationRuleConfig(container, partId, property == null ? "" : property.getPropertyName());
            IValidationRule rule = (IValidationRule)property;
            if (rule != null) {
                ruleConfig.setActive(rule.isActivatedByDefault());
            }
            return ruleConfig;
        }

        @Override
        public Function<IPropertyValue, Object> getValueGetter() {
            return propertyValue -> {
                IPropertyValue iPropertyValue = propertyValue;
                if (iPropertyValue instanceof IValidationRuleConfig) {
                    void ruleConfig;
                    IValidationRuleConfig iValidationRuleConfig = (IValidationRuleConfig)iPropertyValue;
                    IValidationRuleConfig cfr_ignored_0 = (IValidationRuleConfig)iPropertyValue;
                    return ruleConfig.isActive();
                }
                throw new IllegalArgumentException("Illegal parameter " + propertyValue);
            };
        }

        @Override
        public Function<IPropertyValue, Object> getInternalValueGetter() {
            return propertyValue -> {
                IPropertyValue iPropertyValue = propertyValue;
                if (iPropertyValue instanceof ValidationRuleConfig) {
                    void ruleConfig;
                    ValidationRuleConfig validationRuleConfig = (ValidationRuleConfig)iPropertyValue;
                    ValidationRuleConfig cfr_ignored_0 = (ValidationRuleConfig)iPropertyValue;
                    return ruleConfig.isActiveInternal();
                }
                throw new IllegalArgumentException("Illegal parameter " + propertyValue);
            };
        }

        @Override
        public ProductCmptPropertyType getCorrespondingPropertyType() {
            return ProductCmptPropertyType.VALIDATION_RULE;
        }

        @Override
        public BiConsumer<IPropertyValue, Object> getValueSetter() {
            return (propertyValue, value) -> {
                void ruleConfig;
                IPropertyValue iPropertyValue;
                if (!(value instanceof Boolean) || !((iPropertyValue = propertyValue) instanceof IValidationRuleConfig)) {
                    throw new IllegalArgumentException();
                }
                IValidationRuleConfig iValidationRuleConfig = (IValidationRuleConfig)iPropertyValue;
                IValidationRuleConfig cfr_ignored_0 = (IValidationRuleConfig)iPropertyValue;
                ruleConfig.setActive((Boolean)value);
            };
        }

        @Override
        public boolean isPartOfComposite() {
            return false;
        }
    };

    private final Class<? extends IPropertyValue> interfaceClass;
    private final Class<? extends IpsObjectPart> implClass;
    private final String xmlTag;

    private PropertyValueType(Class<? extends IPropertyValue> interfaceClass, Class<? extends IpsObjectPart> implClass, String xmlTag) {
        this.interfaceClass = interfaceClass;
        this.implClass = implClass;
        this.xmlTag = xmlTag;
    }

    public abstract IPropertyValue createPropertyValue(IPropertyValueContainer var1, IProductCmptProperty var2, String var3);

    public abstract Function<IPropertyValue, Object> getValueGetter();

    public abstract BiConsumer<IPropertyValue, Object> getValueSetter();

    public abstract Function<IPropertyValue, Object> getInternalValueGetter();

    public void copyValue(IPropertyValue from, IPropertyValue to) {
        this.getValueSetter().accept(to, this.getValueGetter().apply(from));
    }

    public <T> Comparator<T> getValueComparator() {
        return new NullSafeComparableComparator();
    }

    public abstract ProductCmptPropertyType getCorrespondingPropertyType();

    public Class<? extends IPropertyValue> getInterfaceClass() {
        return this.interfaceClass;
    }

    public Class<? extends IIpsObjectPart> getImplementationClass() {
        return this.implClass;
    }

    public String getValueXmlTagName() {
        return this.xmlTag;
    }

    protected <T extends IIpsObjectPartContainer> T checkContainerType(IIpsObjectPartContainer container, Class<T> concreteContainerClass) {
        if (!concreteContainerClass.isInstance(container)) {
            throw new IllegalArgumentException("The container for " + this.name() + " must be a " + concreteContainerClass.getSimpleName());
        }
        return (T)container;
    }

    public abstract boolean isPartOfComposite();

    public Function<Object, String> getValueToString() {
        return Objects::toString;
    }

    public static PropertyValueType getTypeForValueClass(Class<? extends IIpsObjectPart> partType) {
        PropertyValueType[] propertyValueTypeArray = PropertyValueType.values();
        int n = propertyValueTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyValueType type = propertyValueTypeArray[n2];
            if (type.getInterfaceClass().isAssignableFrom(partType)) {
                return type;
            }
            ++n2;
        }
        throw new IllegalArgumentException("The class " + partType + " does not match any valid PropertyValueType");
    }

    public static PropertyValueType getTypeForXmlTag(String xmlTagName) {
        PropertyValueType[] propertyValueTypeArray = PropertyValueType.values();
        int n = propertyValueTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyValueType type = propertyValueTypeArray[n2];
            if (type.isProperXmlTagName(xmlTagName)) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    protected boolean isProperXmlTagName(String xmlTagName) {
        return this.getValueXmlTagName().equals(xmlTagName);
    }

    public static <T extends IPropertyValue> T createPropertyValue(IPropertyValueContainer parent, IProductCmptProperty productCmptProperty, String partId, Class<T> clazz) {
        return (T)PropertyValueType.getTypeForValueClass(clazz).createPropertyValue(parent, productCmptProperty, partId);
    }

    private static class ValueSetComparator<T>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private ValueSetComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            if (o1 instanceof IValueSet && o2 instanceof IValueSet) {
                return ((IValueSet)o1).compareTo((IValueSet)o2);
            }
            throw new IllegalArgumentException("This comparator could only compare two value sets, but got: " + o1 + " and " + o2);
        }
    }
}

