/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.productcmpt.template;

import java.util.Arrays;
import java.util.List;
import org.faktorips.devtools.model.productcmpt.IProductCmptLink;
import org.faktorips.devtools.model.productcmpt.IPropertyValue;
import org.faktorips.devtools.model.productcmpt.template.ITemplatedValue;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TemplateValueStatus {
    INHERITED("inherited"){

        @Override
        public boolean isAllowedStatus(ITemplatedValue value) {
            return value.findTemplateProperty(value.getIpsProject()) != null;
        }
    }
    ,
    DEFINED("defined"){

        @Override
        public boolean isAllowedStatus(ITemplatedValue value) {
            return true;
        }
    }
    ,
    UNDEFINED("undefined"){

        @Override
        public boolean isAllowedStatus(ITemplatedValue value) {
            return this.isTemplatePropertyValue(value) || this.isLinkWithTemplate(value);
        }

        private boolean isTemplatePropertyValue(ITemplatedValue value) {
            return value instanceof IPropertyValue && value.getTemplatedValueContainer().isProductTemplate();
        }

        private boolean isLinkWithTemplate(ITemplatedValue value) {
            return value instanceof IProductCmptLink && value.findTemplateProperty(value.getIpsProject()) != null;
        }
    };

    private static final List<TemplateValueStatus> VALUES;
    private String xmlValue;

    static {
        VALUES = Arrays.asList(TemplateValueStatus.values());
    }

    private TemplateValueStatus(String xmlValue) {
        this.xmlValue = xmlValue;
    }

    public static TemplateValueStatus valueOfXml(String stringValue, TemplateValueStatus fallbackStatus) {
        for (TemplateValueStatus templateStatus : VALUES) {
            if (!templateStatus.getXmlValue().equals(stringValue)) continue;
            return templateStatus;
        }
        return fallbackStatus;
    }

    public String getXmlValue() {
        return this.xmlValue;
    }

    public TemplateValueStatus getNextStatus(ITemplatedValue value) {
        int index = (VALUES.indexOf((Object)this) + 1) % VALUES.size();
        TemplateValueStatus nextStatus = VALUES.get(index);
        if (nextStatus.isAllowedStatus(value)) {
            return nextStatus;
        }
        return nextStatus.getNextStatus(value);
    }

    public abstract boolean isAllowedStatus(ITemplatedValue var1);
}

