/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.productrelease;

import java.util.regex.Pattern;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.faktorips.devtools.model.plugin.ExtensionPoints;
import org.faktorips.devtools.model.productrelease.IReleaseAndDeploymentOperation;

public class ReleaseExtension {
    public static final String CONFIG_ELEMENT_OPERATION = "operation";
    private static final String ID = "id";
    private static final String VERSION_FORMAT_REGEX = "versionFormatRegex";
    private static final String READABLE_VERSION_FORMAT = "readableVersionFormat";
    private static final String VERSION_MUST_CHANGE = "versionMustChange";
    private final String id;
    private final Pattern versionFormatRegex;
    private final String readableVersionFormat;
    private final boolean versionMustChange;
    private final IConfigurationElement configurationElement;

    public ReleaseExtension(IConfigurationElement configurationElement) {
        this.configurationElement = configurationElement;
        this.id = configurationElement.getAttribute(ID);
        this.versionFormatRegex = Pattern.compile(configurationElement.getAttribute(VERSION_FORMAT_REGEX));
        this.readableVersionFormat = configurationElement.getAttribute(READABLE_VERSION_FORMAT);
        String versionMustChangeAttribute = configurationElement.getAttribute(VERSION_MUST_CHANGE);
        this.versionMustChange = versionMustChangeAttribute == null || Boolean.parseBoolean(versionMustChangeAttribute);
    }

    public String getId() {
        return this.id;
    }

    public Pattern getVersionFormatRegex() {
        return this.versionFormatRegex;
    }

    public String getReadableVersionFormat() {
        return this.readableVersionFormat;
    }

    public boolean isVersionChangeRequired() {
        return this.versionMustChange;
    }

    public IReleaseAndDeploymentOperation createReleaseAndDeploymentOperation() {
        return ExtensionPoints.createExecutableExtension((IExtension)this.configurationElement.getParent(), this.configurationElement, CONFIG_ELEMENT_OPERATION, IReleaseAndDeploymentOperation.class);
    }
}

