/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.tablestructure;

import java.util.Arrays;
import org.faktorips.devtools.model.INamedValue;
import org.faktorips.devtools.model.tablestructure.Messages;
import org.faktorips.util.ArgumentCheck;

public enum ColumnRangeType implements INamedValue
{
    TWO_COLUMN_RANGE("twoColumn", Messages.ColumnRangeType_twoColumns),
    ONE_COLUMN_RANGE_FROM("oneColumnFrom", Messages.ColumnRangeType_fromColumnOnly),
    ONE_COLUMN_RANGE_TO("oneColumnTo", Messages.ColumnRangeType_toColumnOnly);

    private final String id;
    private final String name;

    private ColumnRangeType(String id, String name) {
        ArgumentCheck.notNull((Object)id);
        ArgumentCheck.notNull((Object)name);
        this.id = id;
        this.name = name;
    }

    public static final ColumnRangeType getValueById(String id) {
        return Arrays.stream(ColumnRangeType.values()).filter(s -> s.id.equals(id)).findAny().orElse(null);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isOneColumnFrom() {
        return this.equals(ONE_COLUMN_RANGE_FROM);
    }

    public boolean isOneColumnTo() {
        return this.equals(ONE_COLUMN_RANGE_TO);
    }

    public boolean isTwoColumn() {
        return this.equals(TWO_COLUMN_RANGE);
    }
}

