/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.testcase;

import java.util.Arrays;
import org.faktorips.devtools.model.INamedValue;
import org.faktorips.devtools.model.testcase.Messages;
import org.faktorips.util.ArgumentCheck;

public enum TestRuleViolationType implements INamedValue
{
    VIOLATED("violated", Messages.TestRuleViolationType_Violated, Messages.TestRuleViolationType_TextViolated),
    NOT_VIOLATED("notViolated", Messages.TestRuleViolationType_NotViolated, Messages.TestRuleViolationType_TextNotViolated),
    UNKNOWN("unknown", Messages.TestRuleViolationType_Unknown, Messages.TestRuleViolationType_Unknown);

    private final String id;
    private final String name;
    private final String text;

    private TestRuleViolationType(String id, String name, String text) {
        ArgumentCheck.notNull((Object)id);
        ArgumentCheck.notNull((Object)name);
        ArgumentCheck.notNull((Object)text);
        this.id = id;
        this.name = name;
        this.text = text;
    }

    public static final TestRuleViolationType getTestRuleViolationType(String id) {
        return Arrays.stream(TestRuleViolationType.values()).filter(s -> s.id.equals(id)).findAny().orElse(UNKNOWN);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getText() {
        return this.text;
    }

    public static String mapRuleValueTest(String id) {
        if (id.equals(VIOLATED.getId())) {
            return VIOLATED.getText();
        }
        if (id.equals(NOT_VIOLATED.getId())) {
            return NOT_VIOLATED.getText();
        }
        return id;
    }
}

