/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.testcasetype;

import org.faktorips.devtools.model.testcasetype.Messages;

public enum TestParameterType {
    INPUT("input", Messages.TestParameterType_Input, 0),
    EXPECTED_RESULT("expectedResult", Messages.TestParameterType_ExpectedResult, 1),
    COMBINED("combined", Messages.TestParameterType_Combined, 2);

    private final Integer index;
    private final String id;
    private final String name;

    private TestParameterType(String id, String name, int index) {
        this.id = id;
        this.name = name;
        this.index = index;
    }

    public Integer getIndex() {
        return this.index;
    }

    public static final TestParameterType getTestParameterType(String id) {
        TestParameterType[] testParameterTypeArray = TestParameterType.values();
        int n = testParameterTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TestParameterType type = testParameterTypeArray[n2];
            if (type.getId().equals(id)) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    public static final TestParameterType getTestParameterType(Integer index) {
        TestParameterType[] testParameterTypeArray = TestParameterType.values();
        int n = testParameterTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TestParameterType type = testParameterTypeArray[n2];
            if (type.index.equals(index)) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isTypeMatching(TestParameterType type1, TestParameterType type2) {
        if (type1.equals((Object)type2) || type1.equals((Object)COMBINED) && (type2.equals((Object)INPUT) || type2.equals((Object)EXPECTED_RESULT))) {
            return true;
        }
        return type2.equals((Object)COMBINED) && (type1.equals((Object)INPUT) || type1.equals((Object)EXPECTED_RESULT));
    }

    public static boolean isChildTypeMatching(TestParameterType typeChild, TestParameterType typeParent) {
        return typeChild == typeParent || typeParent == COMBINED && (typeChild == INPUT || typeChild == EXPECTED_RESULT);
    }

    public static int getIndexOfType(TestParameterType type) {
        return type.index;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.getName();
    }
}

