/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.type;

import org.faktorips.devtools.model.productcmpttype.AggregationKind;
import org.faktorips.devtools.model.type.Messages;

public enum AssociationType {
    COMPOSITION_MASTER_TO_DETAIL("comp", Messages.AssociationType_label_composition_master_to_detail),
    COMPOSITION_DETAIL_TO_MASTER("reverseComp", Messages.AssociationType_label_composition_detail_to_master),
    ASSOCIATION("ass", Messages.AssociationType_label_association),
    AGGREGATION("aggr", Messages.AssociationType_label_aggregation);

    private final String id;
    private final String name;

    private AssociationType(String id, String name) {
        this.name = name;
        this.id = id;
    }

    public static final AssociationType getRelationType(String id) {
        if ("agg".equals(id)) {
            return COMPOSITION_MASTER_TO_DETAIL;
        }
        AssociationType[] associationTypeArray = AssociationType.values();
        int n = associationTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AssociationType at = associationTypeArray[n2];
            if (at.getId().equals(id)) {
                return at;
            }
            ++n2;
        }
        return null;
    }

    public boolean isMasterToDetail() {
        return this == COMPOSITION_MASTER_TO_DETAIL || this == AGGREGATION;
    }

    public boolean isCompositionMasterToDetail() {
        return this == COMPOSITION_MASTER_TO_DETAIL;
    }

    public boolean isCompositionDetailToMaster() {
        return this == COMPOSITION_DETAIL_TO_MASTER;
    }

    public boolean isAssoziation() {
        return this == ASSOCIATION;
    }

    public AggregationKind getAggregationKind() {
        if (this.isCompositionMasterToDetail()) {
            return AggregationKind.COMPOSITE;
        }
        if (this == AGGREGATION) {
            return AggregationKind.SHARED;
        }
        return AggregationKind.NONE;
    }

    public String toString() {
        return this.getName();
    }

    public AssociationType getCorrespondingAssociationType() {
        return this.isAssoziation() ? ASSOCIATION : (this.isCompositionDetailToMaster() ? COMPOSITION_MASTER_TO_DETAIL : (this.isCompositionMasterToDetail() ? COMPOSITION_DETAIL_TO_MASTER : null));
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }
}

