/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.type;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.faktorips.devtools.model.ipsproject.IIpsProject;
import org.faktorips.devtools.model.productcmpt.IProductCmpt;
import org.faktorips.devtools.model.productcmpttype.IProductCmptType;
import org.faktorips.devtools.model.type.IType;
import org.faktorips.devtools.model.type.TypeHierarchyVisitor;

public class CommonTypeFinder {
    public IProductCmptType findCommonType(Collection<IProductCmpt> cmpts) {
        if (cmpts == null || cmpts.isEmpty()) {
            return null;
        }
        Iterator<IProductCmpt> cmptsIterator = cmpts.iterator();
        LinkedHashSet<IProductCmptType> candidates = this.createTypeHierarchy(cmptsIterator.next());
        while (cmptsIterator.hasNext()) {
            IProductCmpt nextCmpt = cmptsIterator.next();
            IProductCmptType matchingCandidate = this.findMostSpecificType(candidates, nextCmpt);
            if (matchingCandidate == null) {
                return null;
            }
            this.removeSubtypes(candidates, matchingCandidate);
        }
        if (candidates.isEmpty()) {
            return null;
        }
        return (IProductCmptType)candidates.iterator().next();
    }

    private LinkedHashSet<IProductCmptType> removeSubtypes(LinkedHashSet<IProductCmptType> types, IProductCmptType t) {
        Iterator iterator = types.iterator();
        while (iterator.hasNext() && !((IProductCmptType)iterator.next()).equals(t)) {
            iterator.remove();
        }
        return types;
    }

    private IProductCmptType findMostSpecificType(Set<IProductCmptType> candidateTypes, IProductCmpt cmpt) {
        CommonTypeVisitor<IProductCmptType> typeHierarchyVisitor = new CommonTypeVisitor<IProductCmptType>(cmpt.getIpsProject(), candidateTypes);
        typeHierarchyVisitor.start(cmpt.findProductCmptType(cmpt.getIpsProject()));
        return typeHierarchyVisitor.getCommonType();
    }

    private LinkedHashSet<IProductCmptType> createTypeHierarchy(IProductCmpt cmpt) {
        TypeHierarchyFinder<IProductCmptType> superTypeFinder = new TypeHierarchyFinder<IProductCmptType>(cmpt.getIpsProject());
        superTypeFinder.start(cmpt.findProductCmptType(cmpt.getIpsProject()));
        return new LinkedHashSet<IProductCmptType>(superTypeFinder.getVisited());
    }

    public static IProductCmptType commonTypeOf(Collection<IProductCmpt> prodctCmpts) {
        return new CommonTypeFinder().findCommonType(prodctCmpts);
    }

    private static class CommonTypeVisitor<T extends IType>
    extends TypeHierarchyVisitor<T> {
        private final Set<T> candidateTypes;
        private T commonType = null;

        private CommonTypeVisitor(IIpsProject ipsProject, Set<T> candidateTypes) {
            super(ipsProject);
            this.candidateTypes = candidateTypes;
        }

        public T getCommonType() {
            return this.commonType;
        }

        @Override
        protected boolean visit(T currentType) {
            boolean isCommonType = this.candidateTypes.contains(currentType);
            if (isCommonType) {
                this.commonType = currentType;
            }
            return !isCommonType;
        }
    }

    private static class TypeHierarchyFinder<T extends IType>
    extends TypeHierarchyVisitor<T> {
        public TypeHierarchyFinder(IIpsProject ipsProject) {
            super(ipsProject);
        }

        @Override
        protected boolean visit(T currentType) {
            return true;
        }
    }
}

