/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.util;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.faktorips.runtime.internal.IpsStringUtils;

public class AlphaNumericComparator
implements Comparator<String>,
Serializable {
    private static final long serialVersionUID = 4934515714500740839L;

    @Override
    public int compare(String o1, String o2) {
        return new AlphaNumericCompare(o1, o2).compare();
    }

    private static class AlphaNumericCompare {
        private static final Pattern NUMERIC_PATTERN = Pattern.compile("\\d+");
        private final String input1;
        private final String input2;
        private final Matcher input1Matcher;
        private final Matcher input2Matcher;

        public AlphaNumericCompare(String input1, String input2) {
            this.input1 = input1;
            this.input2 = input2;
            this.input1Matcher = NUMERIC_PATTERN.matcher(input1);
            this.input2Matcher = NUMERIC_PATTERN.matcher(input2);
        }

        public int compare() {
            return this.compareAlphabeticPart(0, 0);
        }

        private int compareAlphabeticPart(int prevPosition1, int prevPosition2) {
            String alphaPart2;
            if (!this.input1Matcher.find() || !this.input2Matcher.find() || this.input1Matcher.start() != this.input2Matcher.start()) {
                return this.input1.substring(prevPosition1).compareTo(this.input2.substring(prevPosition2));
            }
            int startNum = this.input1Matcher.start();
            String alphaPart1 = this.input1.substring(prevPosition1, startNum);
            int alphaResult = alphaPart1.compareTo(alphaPart2 = this.input2.substring(prevPosition2, startNum));
            if (alphaResult == 0) {
                return this.compareNumericPart();
            }
            return alphaResult;
        }

        private int compareNumericPart() {
            String numPart1 = this.input1Matcher.group();
            String numPart2 = this.input2Matcher.group();
            if (IpsStringUtils.isEmpty((String)numPart1) || IpsStringUtils.isEmpty((String)numPart2)) {
                return numPart1.compareTo(numPart2);
            }
            return this.compareAsNumbers(numPart1, numPart2);
        }

        private int compareAsNumbers(String numPart1, String numPart2) {
            BigInteger num1 = new BigInteger(numPart1);
            BigInteger num2 = new BigInteger(numPart2);
            if (num1.equals(num2)) {
                int furtherCompare = this.compareAlphabeticPart(this.input1Matcher.end(), this.input2Matcher.end());
                if (furtherCompare == 0) {
                    return numPart1.compareTo(numPart2);
                }
                return furtherCompare;
            }
            return num1.compareTo(num2);
        }
    }
}

