/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.util;

import org.faktorips.devtools.model.util.IElementMover;
import org.faktorips.util.ArgumentCheck;

public class ArrayElementMover
implements IElementMover {
    private Object[] array;

    public ArrayElementMover(Object[] array) {
        ArgumentCheck.notNull((Object[])array);
        this.array = array;
    }

    @Override
    public int[] move(int[] indices, boolean up) {
        if (up) {
            return this.moveUp(indices);
        }
        return this.moveDown(indices);
    }

    @Override
    public int[] moveUp(int[] indices) {
        if (this.contains(indices, 0)) {
            return indices;
        }
        int[] newSelection = new int[indices.length];
        int j = 0;
        int i = 1;
        while (i < this.array.length) {
            if (this.contains(indices, i)) {
                this.swapElements(i - 1, i);
                newSelection[j] = i - 1;
                ++j;
            }
            ++i;
        }
        return newSelection;
    }

    @Override
    public int[] moveDown(int[] indices) {
        if (this.contains(indices, this.array.length - 1)) {
            return indices;
        }
        int[] newSelection = new int[indices.length];
        int j = 0;
        int i = this.array.length - 2;
        while (i >= 0) {
            if (this.contains(indices, i)) {
                this.swapElements(i, i + 1);
                newSelection[j++] = i + 1;
            }
            --i;
        }
        return newSelection;
    }

    private boolean contains(int[] indices, int index) {
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int indice = nArray[n2];
            if (indice == index) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void swapElements(int index1, int index2) {
        Object temp = this.array[index1];
        this.array[index1] = this.array[index2];
        this.array[index2] = temp;
    }
}

