/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class BeanUtil {
    private static final Map<ClassAndProperty, PropertyDescriptor> PROPERTY_DESCRIPTORS = new HashMap<ClassAndProperty, PropertyDescriptor>();

    private BeanUtil() {
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String propertyName) {
        return PROPERTY_DESCRIPTORS.computeIfAbsent(new ClassAndProperty(clazz, propertyName), cap -> BeanUtil.getPropertyDescriptorInternal(cap.clazz, cap.propertyName));
    }

    private static PropertyDescriptor getPropertyDescriptorInternal(Class<?> clazz, String propertyName) {
        try {
            PropertyDescriptor[] props;
            BeanInfo info = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] propertyDescriptorArray = props = info.getPropertyDescriptors();
            int n = props.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor prop = propertyDescriptorArray[n2];
                if (prop.getName().equals(propertyName)) {
                    return prop;
                }
                ++n2;
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Exception while introspection class " + clazz, e);
        }
        throw new IllegalArgumentException("Class " + clazz + " hasn't got a property " + propertyName);
    }

    private static class ClassAndProperty {
        private final Class<?> clazz;
        private final String propertyName;

        public ClassAndProperty(Class<?> clazz, String propertyName) {
            this.clazz = clazz;
            this.propertyName = propertyName;
        }

        public int hashCode() {
            return Objects.hash(this.clazz, this.propertyName);
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj) {
            void other;
            if (this == obj) {
                return true;
            }
            Object object = obj;
            if (!(object instanceof ClassAndProperty)) {
                return false;
            }
            ClassAndProperty classAndProperty = (ClassAndProperty)object;
            ClassAndProperty cfr_ignored_0 = (ClassAndProperty)object;
            return Objects.equals(this.clazz, other.clazz) && Objects.equals(this.propertyName, other.propertyName);
        }
    }
}

