/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.util;

import org.faktorips.datatype.Datatype;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.model.enums.EnumTypeDatatypeAdapter;
import org.faktorips.devtools.model.enums.IEnumType;

public class DatatypeUtil {
    private DatatypeUtil() {
    }

    public static final boolean isExtensibleEnumType(Datatype datatype) {
        if (datatype == null || !(datatype instanceof EnumTypeDatatypeAdapter)) {
            return false;
        }
        IEnumType enumType = ((EnumTypeDatatypeAdapter)datatype).getEnumType();
        return enumType.isExtensible();
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isCovariant(ValueDatatype datatype1, ValueDatatype datatype2) {
        if (datatype1 == null || datatype2 == null) {
            return false;
        }
        if (datatype1.equals(datatype2)) {
            return true;
        }
        ValueDatatype valueDatatype = datatype1;
        if (valueDatatype instanceof EnumTypeDatatypeAdapter) {
            void enumTypeDatatypeAdapter;
            EnumTypeDatatypeAdapter enumTypeDatatypeAdapter2 = (EnumTypeDatatypeAdapter)valueDatatype;
            EnumTypeDatatypeAdapter cfr_ignored_0 = (EnumTypeDatatypeAdapter)valueDatatype;
            return enumTypeDatatypeAdapter.isCovariant(datatype2);
        }
        return false;
    }

    public static boolean isNullValue(ValueDatatype datatype, String value) {
        return value == null || datatype.isNull(value);
    }

    public static boolean isNonNull(ValueDatatype datatype, String ... values) {
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (DatatypeUtil.isNullValue(datatype, value)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

