/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.util;

import java.util.stream.Stream;
import org.faktorips.devtools.abstraction.AJavaProject;
import org.faktorips.devtools.model.IIpsModelExtensions;
import org.faktorips.devtools.model.IIpsProjectConfigurator;

public class IpsProjectConfigurators {
    private IpsProjectConfigurators() {
    }

    public static Stream<IIpsProjectConfigurator> applicableTo(AJavaProject project) {
        return IIpsModelExtensions.get().getIpsProjectConfigurators().stream().filter(c -> c.canConfigure(project));
    }

    public static final boolean isGroovySupported(AJavaProject javaProject) {
        return IpsProjectConfigurators.applicableTo(javaProject).anyMatch(c -> c.isGroovySupported(javaProject));
    }
}

