/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import org.faktorips.devtools.abstraction.AJavaProject;
import org.faktorips.devtools.model.builder.JaxbSupportVariant;
import org.faktorips.devtools.model.util.IpsProjectConfigurators;
import org.faktorips.devtools.model.util.Messages;
import org.faktorips.runtime.MessageList;
import org.faktorips.runtime.internal.IpsStringUtils;

public class IpsProjectCreationProperties {
    public static final String MSG_CODE_MISSING_PROPERTY = "MISSING_PROPERTY";
    public static final String PROPERTY_RUNTIME_ID_PREFIX = "runtimeIdPrefix";
    public static final String PROPERTY_SOURCE_FOLDER_NAME = "sourceFolderName";
    public static final String PROPERTY_BASE_PACKAGE_NAME = "basePackageName";
    public static final String PROPERTY_PERSISTENCE_SUPPORT = "persistenceSupport";
    public static final String PROPERTY_LOCALES = "locales";
    private String runtimeIdPrefix;
    private String sourceFolderName;
    private String basePackageName;
    private String persistenceSupport;
    private JaxbSupportVariant jaxbSupport;
    private boolean isModelProject;
    private boolean isProductDefinitionProject;
    private boolean isPersistentProject;
    private boolean isGroovySupport;
    private boolean isJaxbEnabled;
    private List<Locale> locales;

    public IpsProjectCreationProperties() {
        this.initializeDefaults();
    }

    private void initializeDefaults() {
        this.runtimeIdPrefix = Messages.IpsProjectCreation_defaultRuntimeIdPrefix;
        this.sourceFolderName = Messages.IpsProjectCreation_defaultSourceFolderName;
        this.basePackageName = Messages.IpsProjectCreation_defaultBasePackageName;
        this.persistenceSupport = "Generic JPA 2.0";
        this.jaxbSupport = JaxbSupportVariant.None;
        this.isModelProject = true;
        this.isProductDefinitionProject = false;
        this.isPersistentProject = false;
        this.isGroovySupport = true;
        this.isJaxbEnabled = false;
        this.locales = new ArrayList<Locale>();
    }

    public String getRuntimeIdPrefix() {
        return this.runtimeIdPrefix;
    }

    public void setRuntimeIdPrefix(String runtimeIdPrefix) {
        this.runtimeIdPrefix = runtimeIdPrefix;
    }

    public String getSourceFolderName() {
        return this.sourceFolderName;
    }

    public void setSourceFolderName(String sourceFolderName) {
        this.sourceFolderName = sourceFolderName;
    }

    public String getBasePackageName() {
        return this.basePackageName;
    }

    public void setBasePackageName(String basePackageName) {
        this.basePackageName = basePackageName;
    }

    public String getPersistenceSupport() {
        return this.persistenceSupport;
    }

    public void setPersistenceSupport(String persistenceSupport) {
        this.persistenceSupport = persistenceSupport;
    }

    public JaxbSupportVariant getJaxbSupport() {
        return this.jaxbSupport;
    }

    public void setJaxbSupport(JaxbSupportVariant jaxbSupport) {
        this.jaxbSupport = jaxbSupport;
    }

    public boolean isModelProject() {
        return this.isModelProject;
    }

    public void setModelProject(boolean isModelProject) {
        this.isModelProject = isModelProject;
    }

    public boolean isProductDefinitionProject() {
        return this.isProductDefinitionProject;
    }

    public void setProductDefinitionProject(boolean isProductDefinitionProject) {
        this.isProductDefinitionProject = isProductDefinitionProject;
    }

    public boolean isPersistentProject() {
        return this.isPersistentProject;
    }

    public void setPersistentProject(boolean isPersistentProject) {
        this.isPersistentProject = isPersistentProject;
    }

    public boolean isJaxbEnabled() {
        return this.isJaxbEnabled;
    }

    public void setJaxbEnabled(boolean isJaxbEnabled) {
        this.isJaxbEnabled = isJaxbEnabled;
    }

    public boolean isGroovySupport() {
        return this.isGroovySupport;
    }

    public void setGroovySupport(boolean isGroovySupport) {
        this.isGroovySupport = isGroovySupport;
    }

    public List<Locale> getLocales() {
        return this.locales;
    }

    public void setLocales(List<Locale> locales) {
        this.locales = locales;
    }

    private String getPropertyName(String property) {
        return switch (property) {
            case PROPERTY_RUNTIME_ID_PREFIX -> Messages.IpsProjectCreationProperties_runtimeIdPrefix;
            case PROPERTY_SOURCE_FOLDER_NAME -> Messages.IpsProjectCreationProperties_sourceFolderName;
            case PROPERTY_BASE_PACKAGE_NAME -> Messages.IpsProjectCreationProperties_basePackageName;
            case PROPERTY_PERSISTENCE_SUPPORT -> Messages.IpsProjectCreationProperties_persistenceSupport;
            case PROPERTY_LOCALES -> Messages.IpsProjectCreationProperties_locales;
            default -> property;
        };
    }

    private void validateNonEmpty(MessageList messages, String property, Supplier<String> getter) {
        if (IpsStringUtils.isEmpty((String)getter.get())) {
            this.missingProperty(messages, property);
        }
    }

    private void missingProperty(MessageList messages, String property) {
        messages.newError(MSG_CODE_MISSING_PROPERTY, MessageFormat.format(Messages.IpsProjectCreationProperties_MsgText_MissingProperty, this.getPropertyName(property)), (Object)this, new String[]{property});
    }

    public MessageList validateRequiredProperties() {
        MessageList messages = new MessageList();
        this.validateNonEmpty(messages, PROPERTY_RUNTIME_ID_PREFIX, this::getRuntimeIdPrefix);
        this.validateNonEmpty(messages, PROPERTY_SOURCE_FOLDER_NAME, this::getSourceFolderName);
        this.validateNonEmpty(messages, PROPERTY_BASE_PACKAGE_NAME, this::getBasePackageName);
        if (this.isPersistentProject) {
            this.validateNonEmpty(messages, PROPERTY_PERSISTENCE_SUPPORT, this::getPersistenceSupport);
        }
        if (this.locales == null || this.locales.isEmpty()) {
            this.missingProperty(messages, PROPERTY_LOCALES);
        }
        return messages;
    }

    public MessageList validate(AJavaProject javaProject) {
        MessageList errorMessages = this.validateRequiredProperties();
        IpsProjectConfigurators.applicableTo(javaProject).map(c -> c.validate(javaProject, this)).forEach(arg_0 -> ((MessageList)errorMessages).add(arg_0));
        return errorMessages;
    }
}

