/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.faktorips.devtools.model.internal.ipsproject.properties.IpsProjectProperties;

public class IpsProjectPropertiesForOldVersion {
    private final Map<String, PropertiesHolder<?>> properties = new ConcurrentHashMap();

    public <T> void add(String propertyName, BiConsumer<IpsProjectProperties, T> setter, T newValue) {
        this.properties.put(propertyName, new PropertiesHolder<T>(false, setter, newValue));
    }

    public boolean checkIfFound(String propertyName) {
        return this.properties.computeIfPresent(propertyName, ($, v) -> v.setFound(true)) != null;
    }

    public <T> void applyNewValue(IpsProjectProperties projectSettings) {
        this.properties.forEach(($, property) -> {
            if (property.isNotFound()) {
                property.getSetter().accept(projectSettings, (IpsProjectProperties)property.getNewValue());
            }
        });
    }

    private static class PropertiesHolder<T> {
        private final BiConsumer<IpsProjectProperties, T> setter;
        private final T newValue;
        private boolean found;

        protected PropertiesHolder(boolean found, BiConsumer<IpsProjectProperties, T> setter, T newValue) {
            this.newValue = newValue;
            this.found = found;
            this.setter = setter;
        }

        protected T getNewValue() {
            return this.newValue;
        }

        protected BiConsumer<IpsProjectProperties, T> getSetter() {
            return this.setter;
        }

        protected PropertiesHolder<T> setFound(boolean found) {
            this.found = found;
            return this;
        }

        protected boolean isNotFound() {
            return !this.found;
        }
    }
}

