/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.util;

import java.util.ArrayList;
import java.util.List;
import org.faktorips.devtools.model.util.IElementMover;
import org.faktorips.util.ArgumentCheck;

public class ListElementMover<T>
implements IElementMover {
    private final List<T> list;

    public ListElementMover(List<T> list) {
        ArgumentCheck.notNull(list);
        this.list = list;
    }

    @Override
    public int[] move(int[] indices, boolean up) {
        if (up) {
            return this.moveUp(indices);
        }
        return this.moveDown(indices);
    }

    @Override
    public int[] moveUp(int[] indices) {
        if (this.contains(indices, 0)) {
            return indices;
        }
        int[] newSelection = new int[indices.length];
        int j = 0;
        int i = 1;
        while (i < this.list.size()) {
            if (this.contains(indices, i)) {
                this.swapElements(i - 1, i);
                newSelection[j] = i - 1;
                ++j;
            }
            ++i;
        }
        return newSelection;
    }

    @Override
    public int[] moveDown(int[] indices) {
        if (this.contains(indices, this.list.size() - 1)) {
            return indices;
        }
        int[] newSelection = new int[indices.length];
        int j = 0;
        int i = this.list.size() - 2;
        while (i >= 0) {
            if (this.contains(indices, i)) {
                this.swapElements(i, i + 1);
                newSelection[j++] = i + 1;
            }
            --i;
        }
        return newSelection;
    }

    private boolean contains(int[] indices, int index) {
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int currentIndex = nArray[n2];
            if (currentIndex == index) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void swapElements(int index1, int index2) {
        T temp = this.list.get(index1);
        this.list.set(index1, this.list.get(index2));
        this.list.set(index2, temp);
    }

    public void moveToIndex(int[] selectedindices, int targetIndex, boolean insertBelow) {
        if (targetIndex < 0 || targetIndex > this.list.size()) {
            return;
        }
        ArrayList<T> buffer = new ArrayList<T>();
        int delta = insertBelow ? 1 : 0;
        int[] nArray = selectedindices;
        int n = selectedindices.length;
        int n2 = 0;
        while (n2 < n) {
            int selectedInd = nArray[n2];
            buffer.add(this.list.get(selectedInd));
            if (selectedInd < targetIndex) {
                --delta;
            }
            ++n2;
        }
        this.list.removeAll(buffer);
        this.list.addAll(targetIndex + delta, buffer);
    }
}

