/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.devtools.model.enums.IEnumAttribute;
import org.faktorips.devtools.model.enums.IEnumType;
import org.faktorips.devtools.model.enums.IEnumValue;
import org.faktorips.devtools.model.internal.pctype.Messages;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsproject.IIpsProject;

public class MarkerEnumUtil {
    private IIpsProject ipsProject;
    private List<IEnumType> markerDefinitions;
    private List<ValueDatatype> enumDatatypes;

    public MarkerEnumUtil(IIpsProject ipsProject) {
        this.ipsProject = ipsProject;
        this.markerDefinitions = this.getMarkerEnumsFromProject();
        this.enumDatatypes = new ArrayList<ValueDatatype>();
        if (this.markerDefinitions != null) {
            for (IEnumType markerDefinition : this.markerDefinitions) {
                ValueDatatype datatype = ipsProject.findValueDatatype(markerDefinition.getQualifiedName());
                this.enumDatatypes.add(datatype);
            }
        }
    }

    public List<IEnumType> getMarkerEnumsFromProject() {
        ArrayList<IIpsSrcFile> enumSrcFiles = new ArrayList<IIpsSrcFile>(this.ipsProject.getMarkerEnums());
        if (!enumSrcFiles.isEmpty()) {
            ArrayList<IEnumType> markerEnums = new ArrayList<IEnumType>();
            for (IIpsSrcFile enumSrcFile : enumSrcFiles) {
                IEnumType enumType = (IEnumType)enumSrcFile.getIpsObject();
                markerEnums.add(enumType);
            }
            return markerEnums;
        }
        return Collections.emptyList();
    }

    public Set<String> getDefinedMarkerIds(List<IEnumType> markerDefinitions) {
        LinkedHashSet<String> definedMarkerIds = new LinkedHashSet<String>();
        for (IEnumType markerDefinition : markerDefinitions) {
            List<IEnumValue> allDefinedMarkerIds = this.getAllMarkers(markerDefinition);
            for (IEnumValue marker : allDefinedMarkerIds) {
                definedMarkerIds.add(this.getIdFor(marker, markerDefinition));
            }
        }
        return definedMarkerIds;
    }

    public Set<String> getDefinedMarkerIds() {
        return this.getDefinedMarkerIds(this.markerDefinitions);
    }

    private List<IEnumValue> getAllMarkers(IEnumType markerDefinition) {
        if (this.hasAvailableMarkers(markerDefinition)) {
            return markerDefinition.getEnumValues();
        }
        return Collections.emptyList();
    }

    public boolean hasAvailableMarkers(IEnumType markerDefinition) {
        return !this.markerDefinitions.isEmpty();
    }

    public boolean hasAvailableMarkers() {
        return !this.markerDefinitions.isEmpty();
    }

    private String getIdFor(IEnumValue enumValue, IEnumType markerDefinition) {
        return enumValue.getEnumAttributeValue(this.findIdAttribute(markerDefinition)).getStringValue();
    }

    private IEnumAttribute findIdAttribute(IEnumType markerDefinition) {
        return markerDefinition.findIdentiferAttribute(this.ipsProject);
    }

    public List<IEnumType> getMarkerEnums() {
        if (this.hasAvailableMarkers()) {
            return this.markerDefinitions;
        }
        return Collections.emptyList();
    }

    public List<String> getMarkerEnumTypeNames() {
        ArrayList<String> enumTypeNames = new ArrayList<String>();
        for (IEnumType markerDefinition : this.markerDefinitions) {
            enumTypeNames.add(markerDefinition.getQualifiedName());
        }
        return enumTypeNames;
    }

    public String getMarkerEnumTypeName() {
        if (!this.markerDefinitions.isEmpty()) {
            return this.markerDefinitions.get(0).getQualifiedName();
        }
        return Messages.MarkerEnumUtil_invalidMarkerEnum;
    }

    public ValueDatatype getEnumDatatype(String id) {
        return this.enumDatatypes.stream().filter(e -> e.isParsable(id)).findFirst().orElse(null);
    }
}

