/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.util;

import java.util.regex.Pattern;
import org.faktorips.datatype.NumericDatatype;
import org.faktorips.datatype.ValueDatatype;
import org.faktorips.datatype.classtypes.DateDatatype;
import org.faktorips.datatype.classtypes.GregorianCalendarDatatype;
import org.faktorips.datatype.classtypes.StringDatatype;
import org.faktorips.runtime.internal.IpsStringUtils;

public class PersistenceUtil {
    private static final Pattern NAME_PATTERN = Pattern.compile("[_\\p{Alpha}]\\w*");

    private PersistenceUtil() {
    }

    public static boolean isValidDatabaseIdentifier(String name) {
        if (IpsStringUtils.isEmpty((String)name)) {
            return false;
        }
        return NAME_PATTERN.matcher(name).matches();
    }

    public static boolean isSupportingDecimalPlaces(ValueDatatype valueDatatype) {
        if (valueDatatype instanceof NumericDatatype) {
            return ((NumericDatatype)valueDatatype).hasDecimalPlaces();
        }
        return false;
    }

    public static boolean isSupportingTemporalType(ValueDatatype valueDatatype) {
        return valueDatatype instanceof GregorianCalendarDatatype || valueDatatype instanceof DateDatatype;
    }

    public static boolean isSupportingLenght(ValueDatatype valueDatatype) {
        return valueDatatype instanceof StringDatatype;
    }
}

