/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.nio.file.Path;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.faktorips.runtime.internal.IpsStringUtils;

public class QNameUtil {
    private QNameUtil() {
    }

    public static final String getPackageName(String qName) {
        if (qName == null) {
            return null;
        }
        int index = qName.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        return qName.substring(0, index);
    }

    public static final String getUnqualifiedName(String qName) {
        if (qName == null) {
            return null;
        }
        int index = qName.lastIndexOf(46);
        if (index == -1) {
            return qName;
        }
        if (index == qName.length() - 1) {
            return "";
        }
        return qName.substring(index + 1);
    }

    public static final String concat(String packagePrefix, String packOrUnqualifiedName) {
        if (IpsStringUtils.isEmpty((String)packagePrefix)) {
            return packOrUnqualifiedName;
        }
        if (IpsStringUtils.isEmpty((String)packOrUnqualifiedName)) {
            return packagePrefix;
        }
        return String.valueOf(packagePrefix) + "." + packOrUnqualifiedName;
    }

    public static final String[] getSegments(String qName) {
        if (qName == null || qName.length() == 0) {
            return new String[0];
        }
        return StringUtils.split((String)qName, (String)".");
    }

    public static final int getSegmentCount(String qName) {
        return QNameUtil.getSegments(qName).length;
    }

    public static final String getSubSegments(String qName, int numberOfSegments) {
        if (qName == null) {
            return null;
        }
        int segmentCount = QNameUtil.getSegmentCount(qName);
        if (segmentCount == 0) {
            return qName;
        }
        if (numberOfSegments > 0 && numberOfSegments < segmentCount) {
            segmentCount = numberOfSegments;
        }
        String[] segments = QNameUtil.getSegments(qName);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < segmentCount) {
            sb.append(segments[i]);
            if (i + 1 < segmentCount) {
                sb.append('.');
            }
            ++i;
        }
        return sb.toString();
    }

    @CheckForNull
    public static final Path toPath(String qName) {
        if (IpsStringUtils.isBlank((String)qName)) {
            return null;
        }
        String[] pathParts = qName.split("\\.");
        if (pathParts.length == 1) {
            return Path.of(pathParts[0], new String[0]);
        }
        return Path.of(pathParts[0], Arrays.copyOfRange(pathParts, 1, pathParts.length));
    }
}

