/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.util;

import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.faktorips.devtools.abstraction.exception.IpsException;
import org.faktorips.devtools.model.IIpsElement;
import org.faktorips.devtools.model.internal.ipsproject.IpsPackageFragment;
import org.faktorips.devtools.model.ipsobject.IIpsSrcFile;
import org.faktorips.devtools.model.ipsproject.IIpsPackageFragment;
import org.faktorips.devtools.model.plugin.IpsStatus;
import org.faktorips.util.ArgumentCheck;
import org.faktorips.util.StringUtil;

public final class RefactorUtil {
    private RefactorUtil() {
    }

    public static IIpsSrcFile copyIpsSrcFile(IIpsSrcFile toBeCopied, IIpsPackageFragment targetIpsPackageFragment, String copyName, IProgressMonitor progressMonitor) {
        ArgumentCheck.notNull((Object[])new Object[]{toBeCopied, targetIpsPackageFragment, copyName});
        ArgumentCheck.isTrue((!toBeCopied.isDirty() ? 1 : 0) != 0);
        Path destinationFolder = targetIpsPackageFragment.getCorrespondingResource().getWorkspaceRelativePath();
        String targetSrcFileName = RefactorUtil.getTargetFileName(toBeCopied, copyName);
        try {
            Path destinationPath = destinationFolder.resolve(targetSrcFileName);
            toBeCopied.getCorrespondingResource().copy(destinationPath, progressMonitor);
        }
        catch (InvalidPathException ipe) {
            throw new IpsException((IStatus)new IpsStatus(ipe));
        }
        return targetIpsPackageFragment.getIpsSrcFile(targetSrcFileName);
    }

    public static String getTargetFileName(IIpsSrcFile toBeCopied, String copyName) {
        return String.valueOf(copyName) + "." + toBeCopied.getIpsObjectType().getFileExtension();
    }

    public static IIpsSrcFile copyIpsSrcFileToTemporary(IIpsSrcFile toBeCopied, IIpsPackageFragment targetIpsPackageFragment, String copyName, IProgressMonitor progressMonitor) {
        ArgumentCheck.notNull((Object[])new Object[]{toBeCopied, targetIpsPackageFragment, copyName});
        long timestamp = new Date().getTime();
        return RefactorUtil.copyIpsSrcFile(toBeCopied, targetIpsPackageFragment, String.valueOf(copyName) + timestamp, progressMonitor);
    }

    public static IIpsSrcFile moveIpsSrcFile(IIpsSrcFile originalSrcFile, IIpsPackageFragment targetIpsPackageFragment, String newName, IProgressMonitor pm) {
        IIpsSrcFile targetSrcFile;
        if (targetIpsPackageFragment.equals(originalSrcFile.getIpsPackageFragment()) && RefactorUtil.isOnlyCapitalizationChanged(originalSrcFile, newName)) {
            IIpsSrcFile tempSrcFile = RefactorUtil.copyIpsSrcFileToTemporary(originalSrcFile, targetIpsPackageFragment, newName, pm);
            originalSrcFile.delete();
            targetSrcFile = RefactorUtil.copyIpsSrcFile(tempSrcFile, targetIpsPackageFragment, newName, pm);
            tempSrcFile.delete();
        } else {
            targetSrcFile = RefactorUtil.copyIpsSrcFile(originalSrcFile, targetIpsPackageFragment, newName, pm);
            originalSrcFile.delete();
        }
        IIpsSrcFile targetElement = targetSrcFile;
        RefactorUtil.updateSortOrder(originalSrcFile.getIpsPackageFragment(), originalSrcFile, targetIpsPackageFragment, targetElement);
        return targetSrcFile;
    }

    public static void updateSortOrder(IIpsPackageFragment originalIpsPackageFragment, IIpsElement originalElement, IIpsPackageFragment targetIpsPackageFragment, IIpsElement targetElement) {
        IpsPackageFragment ipsPackageFragment;
        Comparator<IIpsElement> childOrderComparator;
        if (originalIpsPackageFragment.equals(targetIpsPackageFragment) && (childOrderComparator = (ipsPackageFragment = (IpsPackageFragment)originalIpsPackageFragment).getChildOrderComparator()) instanceof IpsPackageFragment.DefinedOrderComparator) {
            IIpsElement[] elements = ((IpsPackageFragment.DefinedOrderComparator)childOrderComparator).getElements();
            int i = 0;
            while (i < elements.length) {
                if (elements[i].equals(originalElement)) {
                    elements[i] = targetElement;
                    break;
                }
                ++i;
            }
            ipsPackageFragment.setChildOrderComparator(new IpsPackageFragment.DefinedOrderComparator(elements));
        }
    }

    public static boolean isOnlyCapitalizationChanged(IIpsSrcFile fileToBeCopied, String newName) {
        String oldName = StringUtil.getFilenameWithoutExtension((String)fileToBeCopied.getName());
        return newName.toLowerCase().equals(oldName.toLowerCase());
    }
}

