/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.util;

import java.util.Arrays;
import java.util.List;
import org.faktorips.devtools.model.util.IElementMover;

public class SubListElementMover<T>
implements IElementMover {
    private final List<T> list;
    private final List<T> subList;

    public SubListElementMover(List<T> list, List<T> subList) {
        this.list = list;
        this.subList = subList;
    }

    @Override
    public int[] move(int[] indices, boolean up) {
        int[] newIndices = Arrays.copyOf(indices, indices.length);
        if (indices.length == 0) {
            return newIndices;
        }
        int[] outerIndices = this.getOuterIndicesForSubListIndices();
        int[] sortedIndices = Arrays.copyOf(indices, indices.length);
        Arrays.sort(sortedIndices);
        if (up && sortedIndices[0] == 0 || !up && sortedIndices[sortedIndices.length - 1] == this.subList.size() - 1) {
            return newIndices;
        }
        if (up) {
            int i = 0;
            while (i < sortedIndices.length) {
                int sourceIndex = outerIndices[sortedIndices[i]];
                int targetIndex = outerIndices[sortedIndices[i] - 1];
                int n = i++;
                newIndices[n] = newIndices[n] - 1;
                this.swapElements(sourceIndex, targetIndex);
            }
        } else {
            int i = sortedIndices.length - 1;
            while (i >= 0) {
                int sourceIndex = outerIndices[sortedIndices[i]];
                int targetIndex = outerIndices[sortedIndices[i] + 1];
                int n = i--;
                newIndices[n] = newIndices[n] + 1;
                this.swapElements(sourceIndex, targetIndex);
            }
        }
        return newIndices;
    }

    private int[] getOuterIndicesForSubListIndices() {
        int[] outerIndices = new int[this.subList.size()];
        int i = 0;
        while (i < outerIndices.length) {
            outerIndices[i] = this.list.indexOf(this.subList.get(i));
            ++i;
        }
        return outerIndices;
    }

    @Override
    public int[] moveUp(int[] indices) {
        return this.move(indices, true);
    }

    @Override
    public int[] moveDown(int[] indices) {
        return this.move(indices, false);
    }

    private void swapElements(int sourceIndex, int targetIndex) {
        T sourceElement = this.list.get(sourceIndex);
        T targetElement = this.list.get(targetIndex);
        this.list.set(sourceIndex, targetElement);
        this.list.set(targetIndex, sourceElement);
    }
}

