/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.util;

import java.util.Objects;

public class TextRegion
implements Comparable<TextRegion> {
    private final String text;
    private final int start;
    private final int end;

    public TextRegion(String text, int start, int end) {
        this.text = text;
        this.start = start;
        this.end = end;
    }

    public String getText() {
        return this.text;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public TextRegion offset(int offset) {
        return new TextRegion(this.text, this.start + offset, this.end + offset);
    }

    public TextRegion startOffset(int offset) {
        return new TextRegion(this.text, this.start + offset, this.end);
    }

    public TextRegion endOffset(int offset) {
        return new TextRegion(this.text, this.start, this.end + offset);
    }

    public String replaceTextRegion(String inputString, String replacementString) {
        if (!this.isValidStartAndEnd(inputString)) {
            return inputString;
        }
        return String.valueOf(inputString.substring(0, this.getStart())) + replacementString + inputString.substring(this.getEnd());
    }

    private boolean isValidStartAndEnd(String completeIdentifierString) {
        return this.isInitParametersValid() && this.getEnd() <= completeIdentifierString.length();
    }

    private boolean isInitParametersValid() {
        return this.getStart() >= 0 && this.getStart() <= this.getEnd();
    }

    public String getTextRegionString() {
        if (!this.isValidStartAndEnd(this.text)) {
            return this.text;
        }
        return this.text.substring(this.getStart(), this.getEnd());
    }

    public boolean isRelativeChar(int offset, char expected) {
        int index = this.start + offset;
        return index >= 0 && index < this.text.length() && this.text.charAt(index) == expected;
    }

    @Override
    public int compareTo(TextRegion o) {
        if (!Objects.equals(this.text, o.text)) {
            return this.text.compareTo(o.text);
        }
        int compareStart = this.getStart() - o.getStart();
        if (compareStart == 0) {
            return this.getEnd() - o.getEnd();
        }
        return compareStart;
    }

    public int hashCode() {
        return Objects.hash(this.end, this.start, this.text);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TextRegion other = (TextRegion)obj;
        return this.end == other.end && this.start == other.start && Objects.equals(this.text, other.text);
    }

    public String toString() {
        return "TextRegion [text=" + this.text + ", start=" + this.start + ", end=" + this.end + "]";
    }
}

