/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class Tree<T> {
    private final Node<T> root;

    public Tree(T element) {
        this(new Node<T>(null, element));
    }

    private Tree(Node<T> root) {
        this.root = root;
    }

    public Node<T> getRoot() {
        return this.root;
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    public List<T> getAllElements() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        return this.root.getAllElements();
    }

    public <U> Tree<U> transform(Function<? super T, U> transformFunction) {
        if (this.isEmpty()) {
            return Tree.emptyTree();
        }
        return new Tree<U>(this.root.transform(transformFunction, null));
    }

    public String toString() {
        return String.format("Tree [root=%s]", this.root);
    }

    public static <U> Tree<U> emptyTree() {
        return new Tree(null);
    }

    public static class Node<T> {
        private final Node<T> parent;
        private final List<Node<T>> children = new ArrayList<Node<T>>();
        private final T element;

        private Node(Node<T> parent, T element) {
            this.parent = parent;
            this.element = element;
        }

        public boolean hasParent() {
            return this.parent != null;
        }

        public Node<T> getParent() {
            return this.parent;
        }

        public boolean hasChildren() {
            return !this.children.isEmpty();
        }

        public List<Node<T>> getChildren() {
            return Collections.unmodifiableList(this.children);
        }

        public T getElement() {
            return this.element;
        }

        public Node<T> addChild(T s) {
            Node<T> child = new Node<T>(this, s);
            this.addChild(child);
            return child;
        }

        public String toString() {
            return String.format("Node [element=%s]", this.element);
        }

        private boolean addChild(Node<T> child) {
            return this.children.add(child);
        }

        private List<T> getAllElements() {
            ArrayList<T> allIpsSrcFiles = new ArrayList<T>();
            allIpsSrcFiles.add(this.element);
            for (Node<T> child : this.children) {
                allIpsSrcFiles.addAll(child.getAllElements());
            }
            return allIpsSrcFiles;
        }

        private <U> Node<U> transform(Function<? super T, U> transformFunction, Node<U> newParent) {
            Node<U> transformedNode = new Node<U>(newParent, transformFunction.apply(this.element));
            for (Node<T> child : this.children) {
                transformedNode.addChild(child.transform(transformFunction, transformedNode));
            }
            return transformedNode;
        }
    }
}

