/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.util;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.validation.Validator;
import org.faktorips.devtools.abstraction.AVersion;
import org.faktorips.devtools.abstraction.Abstractions;
import org.faktorips.devtools.model.internal.util.XsdValidatorHolder;
import org.faktorips.devtools.model.ipsobject.IpsObjectType;
import org.faktorips.devtools.model.util.XmlParseException;
import org.faktorips.runtime.internal.IpsStringUtils;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;

public class XmlUtil {
    private static final Set<String> ELEMENTS_AND_CHILDREN_WITH_ID = Set.of("ExtensionProperties");
    private static final Map<IpsObjectType, ThreadLocal<Validator>> VALIDATORS = new ConcurrentHashMap<IpsObjectType, ThreadLocal<Validator>>();

    private XmlUtil() {
    }

    public static final DocumentBuilder getDefaultDocumentBuilder() {
        return org.faktorips.runtime.internal.XmlUtil.getDocumentBuilder();
    }

    public static final void setAttributeConvertNullToEmptyString(Element el, String attribute, String value) {
        if (value == null) {
            el.setAttribute(attribute, "");
        } else {
            el.setAttribute(attribute, value);
        }
    }

    public static final String getAttributeConvertEmptyStringToNull(Element el, String attribute) {
        String value = el.getAttribute(attribute);
        if (IpsStringUtils.isEmpty((String)value)) {
            return null;
        }
        return value;
    }

    public static final boolean getBooleanAttributeOrFalse(Element el, String attribute) {
        return el.hasAttribute(attribute) ? Boolean.parseBoolean(el.getAttribute(attribute)) : false;
    }

    public static final String getAttributeOrEmptyString(Element el, String attribute) {
        return el.hasAttribute(attribute) ? el.getAttribute(attribute) : "";
    }

    public static final String dateToXmlDateString(Date date) {
        if (date == null) {
            return "";
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return XmlUtil.gregorianCalendarToXmlDateString(calendar);
    }

    public static final String gregorianCalendarToXmlDateString(GregorianCalendar calendar) {
        if (calendar == null) {
            return "";
        }
        int month = calendar.get(2) + 1;
        int date = calendar.get(5);
        return String.valueOf(calendar.get(1)) + "-" + (month < 10 ? "0" + month : "" + month) + "-" + (date < 10 ? "0" + date : "" + date);
    }

    public static final Date parseXmlDateStringToDate(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        try {
            return XmlUtil.parseGregorianCalendar(s).getTime();
        }
        catch (XmlParseException e) {
            throw new IllegalArgumentException("Can't parse " + s + " to a date!");
        }
    }

    public static final GregorianCalendar parseGregorianCalendar(String s) throws XmlParseException {
        if (IpsStringUtils.isEmpty((String)s)) {
            return null;
        }
        try {
            StringTokenizer tokenizer = new StringTokenizer(s, "-");
            int year = Integer.parseInt(tokenizer.nextToken());
            int month = Integer.parseInt(tokenizer.nextToken());
            int date = Integer.parseInt(tokenizer.nextToken());
            return new GregorianCalendar(year, month - 1, date);
        }
        catch (NumberFormatException e) {
            throw new XmlParseException("Can't parse " + s + " to a date!", e);
        }
    }

    public static final Validator getXsdValidator(IpsObjectType ipsObjectType) {
        return (Validator)VALIDATORS.computeIfAbsent(ipsObjectType, XsdValidatorHolder::new).get();
    }

    public static final void resetXsdValidator(IpsObjectType ipsObjectType) {
        VALIDATORS.remove(ipsObjectType);
    }

    public static final void resetXsdValidators() {
        VALIDATORS.clear();
    }

    public static final Validator getXsdValidator(IpsObjectType ipsObjectType, ErrorHandler customErrorHandler) {
        Validator validator = XmlUtil.getXsdValidator(ipsObjectType);
        validator.setErrorHandler(customErrorHandler);
        return validator;
    }

    public static final Element getFirstElement(Node parent, String tagName) {
        NodeList nl = parent.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Element element;
            if (nl.item(i) instanceof Element && (element = (Element)nl.item(i)).getNodeName().equals(tagName)) {
                return (Element)nl.item(i);
            }
            ++i;
        }
        return null;
    }

    public static final Element getFirstElement(Node parent) {
        NodeList nl = parent.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i) instanceof Element) {
                return (Element)nl.item(i);
            }
            ++i;
        }
        return null;
    }

    public static final Element getElement(Node parent, String tagName, int index) {
        NodeList nl = parent.getChildNodes();
        int count = 0;
        int i = 0;
        while (i < nl.getLength()) {
            Element element;
            if (nl.item(i) instanceof Element && (element = (Element)nl.item(i)).getNodeName().equals(tagName)) {
                if (count == index) {
                    return (Element)nl.item(i);
                }
                ++count;
            }
            ++i;
        }
        throw new IndexOutOfBoundsException();
    }

    public static final Element getElement(Node parent, int index) {
        NodeList nl = parent.getChildNodes();
        int count = 0;
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i) instanceof Element) {
                if (count == index) {
                    return (Element)nl.item(i);
                }
                ++count;
            }
            ++i;
        }
        throw new IndexOutOfBoundsException();
    }

    public static final Text getTextNode(Node node) {
        node.normalize();
        NodeList nl = node.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeType() == 3) {
                return (Text)nl.item(i);
            }
            ++i;
        }
        return null;
    }

    public static final CDATASection getFirstCDataSection(Node node) {
        NodeList nl = node.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i).getNodeType() == 4) {
                return (CDATASection)nl.item(i);
            }
            ++i;
        }
        return null;
    }

    public static final String getCDATAorTextContent(Node node) {
        if (XmlUtil.getFirstCDataSection(node) != null) {
            return XmlUtil.getFirstCDataSection(node).getData();
        }
        if (XmlUtil.getTextNode(node) != null) {
            return XmlUtil.getTextNode(node).getData();
        }
        return null;
    }

    public static final Element addNewChild(Document doc, Node parent, String childName) {
        Element e = doc.createElement(childName);
        parent.appendChild(e);
        return e;
    }

    public static final Node addNewTextChild(Document doc, Node parent, String text) {
        Text n = doc.createTextNode(text);
        parent.appendChild(n);
        return n;
    }

    public static final Node addNewCDATAChild(Document doc, Node parent, String text) {
        CDATASection n = doc.createCDATASection(text);
        parent.appendChild(n);
        return n;
    }

    public static final Node addNewCDATAorTextChild(Document doc, Node parent, String text) {
        if (text == null) {
            return null;
        }
        char[] chars = text.toCharArray();
        boolean toCDATA = false;
        int i = 0;
        while (i < chars.length && !toCDATA) {
            if (chars[i] < ' ' || '~' < chars[i]) {
                toCDATA = true;
            }
            ++i;
        }
        return toCDATA ? XmlUtil.addNewCDATAChild(doc, parent, text) : XmlUtil.addNewTextChild(doc, parent, text);
    }

    @Deprecated
    public String getValueFromElement(Element parent, String propertyName) {
        Element propertyEl = XmlUtil.getFirstElement(parent, propertyName);
        if (propertyEl == null) {
            throw new NullPointerException();
        }
        String isNull = parent.getAttribute("isNull");
        if (Boolean.parseBoolean(isNull)) {
            return null;
        }
        Text textNode = XmlUtil.getTextNode(parent);
        if (textNode == null) {
            return "";
        }
        return textNode.getNodeValue();
    }

    public static final String getSchemaLocation(IpsObjectType ipsObjectType) {
        return XmlUtil.getSchemaLocation(ipsObjectType.getXmlElementName());
    }

    public static final String getIpsProjectPropertiesSchemaLocation() {
        return XmlUtil.getSchemaLocation("ipsProjectProperties");
    }

    public static final String getSchemaLocation(String schemaName) {
        AVersion version = Abstractions.getVersion();
        return String.format("https://doc.faktorzehn.org/schema/faktor-ips/%s/%s.xsd", version.majorMinor().toString(), schemaName);
    }

    public static void removeIds(Element element) {
        if (XmlUtil.isElementWithChildrenExcludedFromRemove(element)) {
            return;
        }
        element.removeAttribute("id");
        NodeList childNodes = element.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            if (childNodes.item(i) instanceof Element) {
                Element child = (Element)childNodes.item(i);
                XmlUtil.removeIds(child);
            }
            ++i;
        }
    }

    private static boolean isElementWithChildrenExcludedFromRemove(Element element) {
        return ELEMENTS_AND_CHILDREN_WITH_ID.contains(element.getNodeName());
    }
}

