/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.value;

import org.faktorips.devtools.model.internal.InternationalStringXmlHelper;
import org.faktorips.devtools.model.internal.value.InternationalStringValue;
import org.faktorips.devtools.model.internal.value.StringValue;
import org.faktorips.devtools.model.util.XmlUtil;
import org.faktorips.devtools.model.value.IValue;
import org.w3c.dom.Element;

public final class ValueFactory {
    private ValueFactory() {
    }

    public static IValue<?> createValue(Element valueEl) {
        if (valueEl == null || Boolean.parseBoolean(valueEl.getAttribute("isNull"))) {
            return new StringValue(null);
        }
        if (InternationalStringXmlHelper.isInternationalStringElement(valueEl)) {
            return InternationalStringValue.createFromXml(valueEl);
        }
        String content = XmlUtil.getCDATAorTextContent(valueEl);
        return new StringValue(content == null ? "" : content);
    }

    public static IValue<?> createValue(boolean isMultilingual, String value) {
        if (isMultilingual) {
            return new InternationalStringValue();
        }
        return new StringValue(value);
    }

    public static IValue<String> createStringValue(String value) {
        return new StringValue(value);
    }
}

