/*
 * Decompiled with CFR 0.152.
 */
package org.faktorips.devtools.model.valueset;

import java.util.Arrays;
import java.util.List;
import org.faktorips.devtools.model.internal.ipsobject.DescriptionHelper;
import org.faktorips.devtools.model.internal.valueset.DerivedValueSet;
import org.faktorips.devtools.model.internal.valueset.EnumValueSet;
import org.faktorips.devtools.model.internal.valueset.RangeValueSet;
import org.faktorips.devtools.model.internal.valueset.StringLengthValueSet;
import org.faktorips.devtools.model.internal.valueset.UnrestrictedValueSet;
import org.faktorips.devtools.model.valueset.IDerivedValueSet;
import org.faktorips.devtools.model.valueset.IEnumValueSet;
import org.faktorips.devtools.model.valueset.IRangeValueSet;
import org.faktorips.devtools.model.valueset.IStringLengthValueSet;
import org.faktorips.devtools.model.valueset.IUnrestrictedValueSet;
import org.faktorips.devtools.model.valueset.IValueSet;
import org.faktorips.devtools.model.valueset.IValueSetOwner;
import org.faktorips.devtools.model.valueset.Messages;
import org.w3c.dom.Element;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ValueSetType {
    UNRESTRICTED("allValues", Messages.ValueSetType__allValues, "AllValues"){

        @Override
        public IUnrestrictedValueSet newValueSet(IValueSetOwner parent, String id) {
            return new UnrestrictedValueSet(parent, id);
        }
    }
    ,
    ENUM("enum", Messages.ValueSetType_enumeration, "Enum"){

        @Override
        public IEnumValueSet newValueSet(IValueSetOwner parent, String id) {
            return new EnumValueSet(parent, id);
        }
    }
    ,
    RANGE("range", Messages.ValueSetType_range, "Range"){

        @Override
        public IRangeValueSet newValueSet(IValueSetOwner parent, String id) {
            return new RangeValueSet(parent, id);
        }
    }
    ,
    DERIVED("derived", Messages.ValueSetType_derived, "Derived"){

        @Override
        public IDerivedValueSet newValueSet(IValueSetOwner parent, String id) {
            return new DerivedValueSet(parent, id);
        }
    }
    ,
    STRINGLENGTH("stringLength", Messages.ValueSetType_stringLength, "StringLength"){

        @Override
        public IStringLengthValueSet newValueSet(IValueSetOwner parent, String id) {
            return new StringLengthValueSet(parent, id);
        }
    };

    private final String id;
    private final String name;
    private final String xmlTag;

    private ValueSetType(String id, String name, String xmlTag) {
        this.id = id;
        this.name = name;
        this.xmlTag = xmlTag;
    }

    public abstract IValueSet newValueSet(IValueSetOwner var1, String var2);

    public static IValueSet newValueSet(Element valueSetNode, IValueSetOwner parent, String id) {
        Element element = DescriptionHelper.getFirstNoneDescriptionElement(valueSetNode);
        if (element == null) {
            return null;
        }
        String tagName = element.getNodeName();
        return Arrays.stream(ValueSetType.values()).filter(v -> v.xmlTag.equals(tagName)).findFirst().map(v -> v.newValueSet(parent, id)).orElse(null);
    }

    public static List<ValueSetType> getValueSetTypesAsList() {
        return Arrays.asList(ValueSetType.values());
    }

    public static List<ValueSetType> getNumericValueSetTypesAsList() {
        return Arrays.asList(UNRESTRICTED, RANGE, ENUM, DERIVED);
    }

    public static ValueSetType getValueSetTypeByName(String name) {
        ValueSetType[] valueSetTypeArray = ValueSetType.values();
        int n = valueSetTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ValueSetType type = valueSetTypeArray[n2];
            if (type.getName().equals(name)) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    public boolean isUnrestricted() {
        return this == UNRESTRICTED;
    }

    public boolean isRange() {
        return this == RANGE;
    }

    public boolean isEnum() {
        return this == ENUM;
    }

    public boolean isDerived() {
        return this == DERIVED;
    }

    public boolean isStringLength() {
        return this == STRINGLENGTH;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }
}

